package view

import "time"

// V1ManagerEventView contains the fields of a manager event record.
type V1ManagerEventView struct {
	*V1EventView

	EmailNotificationCount int `json:"email_notification_count"`
}

// GetV1AvailableManagerEventListInput contains the required fields for
// querying for a list of manager event objects.
type GetV1AvailableManagerEventListInput struct {
	ChannelID        int
	EndTimeUTCAfter  *time.Time
	EndTimeUTCBefore *time.Time
	OrderBy          *string
}

// GetV1AvailableManagerEventListOutput contains the fields from the response
// of making a GET request via GetV1AvailableManagerEventList.
type GetV1AvailableManagerEventListOutput struct {
	Status  int                                      `json:"status"`
	Message string                                   `json:"message"`
	Meta    GetV1AvailableManagerEventListOutputMeta `json:"meta"`
	Data    []*V1ManagerEventView                    `json:"data"`
}

// GetV1AvailableManagerEventListOutputMeta contains the meta-data of
// GetV1AvailableManagerEventListOutput.
type GetV1AvailableManagerEventListOutputMeta struct {
	ChannelID        int       `json:"channel_id"`
	EndTimeUTCAfter  time.Time `json:"end_time_utc_after"`
	EndTimeUTCBefore time.Time `json:"end_time_utc_before"`
	OrderBy          string    `json:"order_by"`
	Status           string    `json:"status"`
	Limit            int       `json:"limit"`
}
