package view

// GetV1UserEventNotificationSettingsOutput contains the fields for the
// response to the "get user's event notification settings" HTTP GET request.
type GetV1UserEventNotificationSettingsOutput struct {
	Status  int                                          `json:"status"`
	Message string                                       `json:"message"`
	Data    GetV1UserEventNotificationSettingsOutputData `json:"data"`
}

// GetV1UserEventNotificationSettingsOutputData indicates whether a type of event
// notification is enabled.
type GetV1UserEventNotificationSettingsOutputData struct {
	EmailEnabled bool `json:"email_enabled"`
}

// GetV1UserEventsNotificationSettingsOutput contains the fields for the
// response to the "get user's events notification settings" HTTP GET request.
type GetV1UserEventsNotificationSettingsOutput struct {
	Status  int                                             `json:"status"`
	Message string                                          `json:"message"`
	Data    []GetV1UserEventsNotificationSettingsOutputData `json:"data"`
}

// GetV1UserEventsNotificationSettingsOutputData indicates whether a type of event
// notification is enabled.
type GetV1UserEventsNotificationSettingsOutputData struct {
	EventID      int  `json:"event_id"`
	EmailEnabled bool `json:"email_enabled"`
}

// PutV1UserEventNotificationSettingsInput contains the fields in the
// request body of the "update user's event notifications" HTTP PUT request.
type PutV1UserEventNotificationSettingsInput struct {
	EmailEnabled bool `json:"email_enabled"`
}

// PutV1UserEventNotificationSettingsOutput contains the fields for the
// response to the "update user's event notifications" HTTP PUT request.
type PutV1UserEventNotificationSettingsOutput struct {
	Status  int                                          `json:"status"`
	Message string                                       `json:"message"`
	Data    PutV1UserEventNotificationSettingsOutputData `json:"data"`
}

// PutV1UserEventNotificationSettingsOutputData indicates whether a type
// of event notification is enabled.
type PutV1UserEventNotificationSettingsOutputData struct {
	EmailEnabled bool `json:"email_enabled"`
}
