/* Development */
drop table if exists development.microservice_twitch_atlas_account_manager;
create table development.microservice_twitch_atlas_account_manager
(
    account_manager_id int not null auto_increment,
    account_manager_ldap_name nvarchar(100) not null,
    account_manager_first_name nvarchar(100) not null,
    account_manager_last_name nvarchar(100) not null,
    account_manager_email nvarchar(100) not null,
    approving_manager_amazon_id nvarchar(100) null,
    approving_manager_name nvarchar(100) null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    hash nvarchar(100) not null,
    primary key (account_manager_id)
);
create unique index ux_microservice_twitch_atlas_account_manager on development.microservice_twitch_atlas_account_manager (account_manager_ldap_name);

/* Staging */
drop table if exists staging.microservice_twitch_atlas_account_manager;
create table staging.microservice_twitch_atlas_account_manager
(
    account_manager_id int not null auto_increment,
    account_manager_ldap_name nvarchar(100) not null,
    account_manager_first_name nvarchar(100) not null,
    account_manager_last_name nvarchar(100) not null,
    account_manager_email nvarchar(100) not null,
    approving_manager_amazon_id nvarchar(100) null,
    approving_manager_name nvarchar(100) null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    hash nvarchar(100) not null,
    primary key (account_manager_id)
);
create unique index ux_microservice_twitch_atlas_account_manager on staging.microservice_twitch_atlas_account_manager (account_manager_ldap_name);

/* Production */
drop table if exists production.microservice_twitch_atlas_account_manager;
create table production.microservice_twitch_atlas_account_manager
(
    account_manager_id int not null auto_increment,
    account_manager_ldap_name nvarchar(100) not null,
    account_manager_first_name nvarchar(100) not null,
    account_manager_last_name nvarchar(100) not null,
    account_manager_email nvarchar(100) not null,
    approving_manager_amazon_id nvarchar(100) null,
    approving_manager_name nvarchar(100) null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    hash nvarchar(100) not null,
    primary key (account_manager_id)
);
create unique index ux_microservice_twitch_atlas_account_manager on production.microservice_twitch_atlas_account_manager (account_manager_ldap_name);
