/* Development */
drop table if exists development.microservice_twitch_atlas_activity_log;
create table development.microservice_twitch_atlas_activity_log
(
    id int not null auto_increment,
    message_timestamp datetime not null,
    message varchar(8000) not null,
    controller varchar(500) not null,
    action varchar(500) not null,
    user varchar(500) null,
    tracking_id varchar(500) not null, /* If loading from S3: This is the log path, otherwise it's a guid */
    tracking_tag varchar(100) not null, /* If loading from S3: This is the etag, otherwise it's the ConstantsWorker GUID */
    tracking_date datetime not null,
    hash nvarchar(100) not null,
    primary key (id)
);

/* Staging */
drop table if exists staging.microservice_twitch_atlas_activity_log;
create table staging.microservice_twitch_atlas_activity_log
(
    id int not null auto_increment,
    message_timestamp datetime not null,
    message varchar(8000) not null,
    controller varchar(500) not null,
    action varchar(500) not null,
    user varchar(500) null,
    tracking_id varchar(500) not null, /* If loading from S3: This is the log path, otherwise it's a guid */
    tracking_tag varchar(100) not null, /* If loading from S3: This is the etag, otherwise it's the ConstantsWorker GUID */
    tracking_date datetime not null,
    hash nvarchar(100) not null,
    primary key (id)
);

/* Production */
drop table if exists production.microservice_twitch_atlas_activity_log;
create table production.microservice_twitch_atlas_activity_log
(
    id int not null auto_increment,
    message_timestamp datetime not null,
    message varchar(8000) not null,
    controller varchar(500) not null,
    action varchar(500) not null,
    user varchar(500) null,
    tracking_id varchar(500) not null, /* If loading from S3: This is the log path, otherwise it's a guid */
    tracking_tag varchar(100) not null, /* If loading from S3: This is the etag, otherwise it's the ConstantsWorker GUID */
    tracking_date datetime not null,
    hash nvarchar(100) not null,
    primary key (id)
);