/* This table has been dropped in favor of AggregatePremiumContentCreatorStats */
/* Development */
drop table if exists development.microservice_twitch_atlas_aggregate_pcc_stats;
create table development.microservice_twitch_atlas_aggregate_pcc_stats (
  stat_id int not null auto_increment,
  premium_content_creator_id int(11) not null,
  measurement_date datetime not null,
  total_revenue float not null,
  hours_watched float not null,
  hours_broadcast float not null,
  last_update_time datetime not null,
  hash nvarchar(100) not null,
  primary key (stat_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_aggregate_pcc_stats on development.microservice_twitch_atlas_aggregate_pcc_stats (premium_content_creator_id, measurement_date);

/* Staging */
drop table if exists staging.microservice_twitch_atlas_aggregate_pcc_stats;
create table staging.microservice_twitch_atlas_aggregate_pcc_stats (
  stat_id int not null auto_increment,
  premium_content_creator_id int(11) not null,
  measurement_date datetime not null,
  total_revenue float not null,
  hours_watched float not null,
  hours_broadcast float not null,
  last_update_time datetime not null,
  hash nvarchar(100) not null,
  primary key (stat_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_aggregate_pcc_stats on staging.microservice_twitch_atlas_aggregate_pcc_stats (premium_content_creator_id, measurement_date);

/* Production */
drop table if exists production.microservice_twitch_atlas_aggregate_pcc_stats;
create table production.microservice_twitch_atlas_aggregate_pcc_stats (
  stat_id int not null auto_increment,
  premium_content_creator_id int(11) not null,
  measurement_date datetime not null,
  total_revenue float not null,
  hours_watched float not null,
  hours_broadcast float not null,
  last_update_time datetime not null,
  hash nvarchar(100) not null,
  primary key (stat_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_aggregate_pcc_stats on production.microservice_twitch_atlas_aggregate_pcc_stats (premium_content_creator_id, measurement_date);