/* Development */
drop table if exists development.microservice_twitch_atlas_contract_account_manager_map;
create table development.microservice_twitch_atlas_contract_account_manager_map
(
    contract_account_manager_map_id int not null auto_increment,
    contract_id int not null,
    account_manager_id int not null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(100) not null,
    hash nvarchar(100) not null,
    updated_time datetime null,
    updated_user nvarchar(100) null,
    primary key (contract_account_manager_map_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_contract_account_manager_map on development.microservice_twitch_atlas_contract_account_manager_map (contract_id, account_manager_id);

/* Staging */
drop table if exists staging.microservice_twitch_atlas_contract_account_manager_map;
create table staging.microservice_twitch_atlas_contract_account_manager_map
(
    contract_account_manager_map_id int not null auto_increment,
    contract_id int not null,
    account_manager_id int not null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(100) not null,
    hash nvarchar(100) not null,
    updated_time datetime null,
    updated_user nvarchar(100) null,
    primary key (contract_account_manager_map_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_contract_account_manager_map on staging.microservice_twitch_atlas_contract_account_manager_map (contract_id, account_manager_id);

/* Production */
drop table if exists production.microservice_twitch_atlas_contract_account_manager_map;
create table production.microservice_twitch_atlas_contract_account_manager_map
(
    contract_account_manager_map_id int not null auto_increment,
    contract_id int not null,
    account_manager_id int not null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(100) not null,
    hash nvarchar(100) not null,
    updated_time datetime null,
    updated_user nvarchar(100) null,
    primary key (contract_account_manager_map_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_contract_account_manager_map on production.microservice_twitch_atlas_contract_account_manager_map (contract_id, account_manager_id);