/* Development */
drop table if exists development.microservice_twitch_atlas_contracts;
create table development.microservice_twitch_atlas_contracts
(
    contract_id int not null auto_increment,
    contract_name nvarchar(100) not null,
    contract_type varchar(100) not null, /* Revenue Share, Minimum Guarantee, License Fee, (Other)*/
    premium_content_creator_id int not null,
    start_date datetime not null,
    end_date datetime not null,
    revenue_share_enabled boolean not null, /* Yes / No if revenue share applies */
    ad_revenue_contract_type varchar(100) null, /* standard, premium, custom */
    ad_revenue_share_type_tier_1 varchar(100) null,
    ad_revenue_share_amount_tier_1 float null,
    ad_revenue_share_type_tier_2 varchar(100) null,
    ad_revenue_share_amount_tier_2 float null,
    ad_revenue_share_type_tier_3 varchar(100) null,
    ad_revenue_share_amount_tier_3 float null,
    bits_revenue_share_percent float null, /* xx.xx% 0..1, front end multiplies by 100 for display */
    subs_revenue_share_percent float null,  /* xx.xx% 0..1, front end multiplies by 100 for display */
    ad_density_per_hour float null, /* 0..60 -- 60 would represent an ad every minute */
    exclusivity_enabled boolean not null, /* true: contract includes the exclusive right to broadcast contractual content */
    ad_prerolls_enabled boolean not null, /* whether PCC O&O Channels will have preroll ads active by default */
    sponsorship_enabled boolean not null, /* whether Twitch has the right to sell sponsorships against the contractual content */
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(100) not null,
    hash nvarchar(100) not null,
    primary key (contract_id)
);

drop table if exists development.microservice_twitch_atlas_contract_channels;
create table development.microservice_twitch_atlas_contract_channels
(
    contract_channel_id int not null auto_increment,
    contract_id int not null,
    channel_id bigint not null,
    custom_start_date datetime null, /* allows a user to specify that a channel starts after the default contract start date */
    custom_end_date datetime null, /* allows a user to specify that a channel ends before the default contract end date */
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(100) not null,
    hash nvarchar(100) not null,
    primary key (contract_channel_id)
);
create unique index uix_microservice_twitch_atlas_contract_channels on development.microservice_twitch_atlas_contract_channels (contract_id, channel_id);

create or replace view development.vw_atlas_contract_channels as
select
	a.contract_id,
    a.contract_name,
    a.contract_type,
    a.start_date as contract_start_date,
    a.end_date as contract_end_date,
    a.revenue_share_enabled,
    a.ad_revenue_contract_type,
    a.ad_revenue_share_type_tier_1,
    a.ad_revenue_share_amount_tier_1,
    a.ad_revenue_share_type_tier_2,
    a.ad_revenue_share_amount_tier_2,
    a.ad_revenue_share_type_tier_3,
    a.ad_revenue_share_amount_tier_3,
    a.bits_revenue_share_percent,
    a.subs_revenue_share_percent,
    a.ad_density_per_hour,
    a.exclusivity_enabled,
    a.ad_prerolls_enabled,
    a.sponsorship_enabled,
    b.channel_id,
    b.custom_start_date as channel_contract_start_date,
    b.custom_end_date as channel_contract_end_date,
    a.account_manager_map_id,
    d.account_manager_id,
    d.account_manager_ldap_name,
    d.account_manager_first_name,
    d.account_manager_last_name,
    d.account_manager_email,
    d.approving_manager_amazon_id,
    d.approving_manager_name,
    e.premium_content_creator_id,
    e.premium_content_creator_name,
    e.premium_content_creator_type,
    case when a.is_active = true and b.is_active = true /*and c.is_active = true */and d.is_active = true and e.is_active = true then true else false end as is_active
-- Take base contract
from development.microservice_twitch_atlas_contracts as a
-- Get channels associated with the contract
inner join development.microservice_twitch_atlas_contract_channels as b
	on a.contract_id = b.contract_id
-- Get account manager mapping associated with the contract
inner join development.microservice_twitch_atlas_contract_account_manager_map as c
	on a.contract_id = c.contract_id
-- Get account manager details associated with the contract
inner join development.microservice_twitch_atlas_account_manager as d
	on c.account_manager_id = d.account_manager_id
-- Get premium content creator details associated with the contract
inner join development.microservice_twitch_atlas_premium_content_creator as e
	on a.premium_content_creator_id = e.premium_content_creator_id
;

/*
tournymasterbot  12:23 PM
Custom Start Date - (optional, allows a user to specify that a channel starts after the default contract start date.)
Custom End Date - (optional, allows a user to specify that a channel ends before the default contract end date.)
Does the start date have to be after, and the end date have to be before? (For example, if a channel is doing coverage of blizcon and they have a preshow or post-show-party, would that be appropriate for these fields?

Paul Jenni  12:24 PM
AM name, Channel, PCC Name, Year, We could even conceivably want to search by game (which would involve drilling to the event level).
12:26
For Contracts, the override start and end dates should only be between the contract start and end dates. If contractual activity starts earlier than the specified Contract start date, a user should move the contract start date earlier.
*/

/* Staging */
drop table if exists staging.microservice_twitch_atlas_contracts;
create table staging.microservice_twitch_atlas_contracts
(
    contract_id int not null auto_increment,
    contract_name nvarchar(100) not null,
    contract_type varchar(100) not null, /* Revenue Share, Minimum Guarantee, License Fee, (Other)*/
    premium_content_creator_id int not null,
    start_date datetime not null,
    end_date datetime not null,
    revenue_share_enabled boolean not null, /* Yes / No if revenue share applies */
    ad_revenue_contract_type varchar(100) null, /* standard, premium, custom */
    ad_revenue_share_type_tier_1 varchar(100) null,
    ad_revenue_share_amount_tier_1 float null,
    ad_revenue_share_type_tier_2 varchar(100) null,
    ad_revenue_share_amount_tier_2 float null,
    ad_revenue_share_type_tier_3 varchar(100) null,
    ad_revenue_share_amount_tier_3 float null,
    bits_revenue_share_percent float null, /* xx.xx% 0..1, front end multiplies by 100 for display */
    subs_revenue_share_percent float null,  /* xx.xx% 0..1, front end multiplies by 100 for display */
    ad_density_per_hour float null, /* 0..60 -- 60 would represent an ad every minute */
    exclusivity_enabled boolean not null, /* true: contract includes the exclusive right to broadcast contractual content */
    ad_prerolls_enabled boolean not null, /* whether PCC O&O Channels will have preroll ads active by default */
    sponsorship_enabled boolean not null, /* whether Twitch has the right to sell sponsorships against the contractual content */
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(100) not null,
    hash nvarchar(100) not null,
    primary key (contract_id)
);

drop table if exists staging.microservice_twitch_atlas_contract_channels;
create table staging.microservice_twitch_atlas_contract_channels
(
    contract_channel_id int not null auto_increment,
    contract_id int not null,
    channel_id bigint not null,
    custom_start_date datetime null, /* allows a user to specify that a channel starts after the default contract start date */
    custom_end_date datetime null, /* allows a user to specify that a channel ends before the default contract end date */
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(100) not null,
    hash nvarchar(100) not null,
    primary key (contract_channel_id)
);
create unique index uix_microservice_twitch_atlas_contract_channels on staging.microservice_twitch_atlas_contract_channels (contract_id, channel_id);

create or replace view staging.vw_atlas_contract_channels as
select
	a.contract_id,
    a.contract_name,
    a.contract_type,
    a.start_date as contract_start_date,
    a.end_date as contract_end_date,
    a.revenue_share_enabled,
    a.ad_revenue_contract_type,
    a.ad_revenue_share_type_tier_1,
    a.ad_revenue_share_amount_tier_1,
    a.ad_revenue_share_type_tier_2,
    a.ad_revenue_share_amount_tier_2,
    a.ad_revenue_share_type_tier_3,
    a.ad_revenue_share_amount_tier_3,
    a.bits_revenue_share_percent,
    a.subs_revenue_share_percent,
    a.ad_density_per_hour,
    a.exclusivity_enabled,
    a.ad_prerolls_enabled,
    a.sponsorship_enabled,
    b.channel_id,
    b.custom_start_date as channel_contract_start_date,
    b.custom_end_date as channel_contract_end_date,
    a.account_manager_map_id,
    d.account_manager_id,
    d.account_manager_ldap_name,
    d.account_manager_first_name,
    d.account_manager_last_name,
    d.account_manager_email,
    d.approving_manager_amazon_id,
    d.approving_manager_name,
    e.premium_content_creator_id,
    e.premium_content_creator_name,
    e.premium_content_creator_type,
    case when a.is_active = true and b.is_active = true /*and c.is_active = true */and d.is_active = true and e.is_active = true then true else false end as is_active
-- Take base contract
from staging.microservice_twitch_atlas_contracts as a
-- Get channels associated with the contract
inner join staging.microservice_twitch_atlas_contract_channels as b
	on a.contract_id = b.contract_id
-- Get account manager mapping associated with the contract
inner join staging.microservice_twitch_atlas_contract_account_manager_map as c
	on a.contract_id = c.contract_id
-- Get account manager details associated with the contract
inner join staging.microservice_twitch_atlas_account_manager as d
	on c.account_manager_id = d.account_manager_id
-- Get premium content creator details associated with the contract
inner join staging.microservice_twitch_atlas_premium_content_creator as e
	on a.premium_content_creator_id = e.premium_content_creator_id
;

/* Production */
drop table if exists production.microservice_twitch_atlas_contracts;
create table production.microservice_twitch_atlas_contracts
(
    contract_id int not null auto_increment,
    contract_name nvarchar(100) not null,
    contract_type varchar(100) not null, /* Revenue Share, Minimum Guarantee, License Fee, (Other)*/
    premium_content_creator_id int not null,
    start_date datetime not null,
    end_date datetime not null,
    revenue_share_enabled boolean not null, /* Yes / No if revenue share applies */
    ad_revenue_contract_type varchar(100) null, /* standard, premium, custom */
    ad_revenue_share_type_tier_1 varchar(100) null,
    ad_revenue_share_amount_tier_1 float null,
    ad_revenue_share_type_tier_2 varchar(100) null,
    ad_revenue_share_amount_tier_2 float null,
    ad_revenue_share_type_tier_3 varchar(100) null,
    ad_revenue_share_amount_tier_3 float null,
    bits_revenue_share_percent float null, /* xx.xx% 0..1, front end multiplies by 100 for display */
    subs_revenue_share_percent float null,  /* xx.xx% 0..1, front end multiplies by 100 for display */
    ad_density_per_hour float null, /* 0..60 -- 60 would represent an ad every minute */
    exclusivity_enabled boolean not null, /* true: contract includes the exclusive right to broadcast contractual content */
    ad_prerolls_enabled boolean not null, /* whether PCC O&O Channels will have preroll ads active by default */
    sponsorship_enabled boolean not null, /* whether Twitch has the right to sell sponsorships against the contractual content */
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(100) not null,
    hash nvarchar(100) not null,
    primary key (contract_id)
);

drop table if exists production.microservice_twitch_atlas_contract_channels;
create table production.microservice_twitch_atlas_contract_channels
(
    contract_channel_id int not null auto_increment,
    contract_id int not null,
    channel_id bigint not null,
    custom_start_date datetime null, /* allows a user to specify that a channel starts after the default contract start date */
    custom_end_date datetime null, /* allows a user to specify that a channel ends before the default contract end date */
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(100) not null,
    hash nvarchar(100) not null,
    primary key (contract_channel_id)
);
create unique index uix_microservice_twitch_atlas_contract_channels on production.microservice_twitch_atlas_contract_channels (contract_id, channel_id);

create or replace view production.vw_atlas_contract_channels as
select
	a.contract_id,
    a.contract_name,
    a.contract_type,
    a.start_date as contract_start_date,
    a.end_date as contract_end_date,
    a.revenue_share_enabled,
    a.ad_revenue_contract_type,
    a.ad_revenue_share_type_tier_1,
    a.ad_revenue_share_amount_tier_1,
    a.ad_revenue_share_type_tier_2,
    a.ad_revenue_share_amount_tier_2,
    a.ad_revenue_share_type_tier_3,
    a.ad_revenue_share_amount_tier_3,
    a.bits_revenue_share_percent,
    a.subs_revenue_share_percent,
    a.ad_density_per_hour,
    a.exclusivity_enabled,
    a.ad_prerolls_enabled,
    a.sponsorship_enabled,
    b.channel_id,
    b.custom_start_date as channel_contract_start_date,
    b.custom_end_date as channel_contract_end_date,
    a.account_manager_map_id,
    d.account_manager_id,
    d.account_manager_ldap_name,
    d.account_manager_first_name,
    d.account_manager_last_name,
    d.account_manager_email,
    d.approving_manager_amazon_id,
    d.approving_manager_name,
    e.premium_content_creator_id,
    e.premium_content_creator_name,
    e.premium_content_creator_type,
    case when a.is_active = true and b.is_active = true /*and c.is_active = true */and d.is_active = true and e.is_active = true then true else false end as is_active
-- Take base contract
from production.microservice_twitch_atlas_contracts as a
-- Get channels associated with the contract
inner join production.microservice_twitch_atlas_contract_channels as b
	on a.contract_id = b.contract_id
-- Get account manager mapping associated with the contract
inner join production.microservice_twitch_atlas_contract_account_manager_map as c
	on a.contract_id = c.contract_id
-- Get account manager details associated with the contract
inner join production.microservice_twitch_atlas_account_manager as d
	on c.account_manager_id = d.account_manager_id
-- Get premium content creator details associated with the contract
inner join production.microservice_twitch_atlas_premium_content_creator as e
	on a.premium_content_creator_id = e.premium_content_creator_id
;