/* Development */
drop table if exists development.microservice_twitch_atlas_product;
create table development.microservice_twitch_atlas_product
(
    product_id int not null auto_increment, 
    product_name nvarchar(128) not null, 
    product_owner nvarchar(128) not null,
    start_time datetime not null,
    end_time datetime not null,
    created_time datetime not null,
    created_user varchar(64) not null,
    primary key (product_id)
);

drop table if exists development.microservice_twitch_atlas_season;
create table development.microservice_twitch_atlas_season
(
    season_id int not null auto_increment,
    product_id int not null,
    season_name nvarchar(128) not null,
    start_time datetime not null,
    end_time datetime not null,
    estimated_hours_broadcast float not null,
    prize_pool float not null,
    created_time datetime not null,
    created_user varchar(64) not null,
    primary key (season_id)
);

drop table if exists development.microservice_twitch_atlas_event;
create table development.microservice_twitch_atlas_event
(
    event_id int not null auto_increment, 
    season_id int not null,
    product_id int not null,
    event_name nvarchar(128) not null, 
    start_time datetime not null, 
    end_time datetime not null, 
    event_type varchar(128) not null, 
    estimated_ccv int not null, 
    hours_broadcast float not null, 
    created_time datetime not null, 
    created_user varchar(64) not null,
    primary key (event_id)
);

drop table if exists development.microservice_twitch_atlas_stream;
create table development.microservice_twitch_atlas_stream
(
    stream_id int not null auto_increment, 
    season_id int not null, 
    event_id int not null,
    product_id int not null, 
    channel_id int not null, 
    stream_login varchar(128) not null, 
    game_name nvarchar(128) not null, 
    start_time datetime not null, 
    end_time datetime not null, 
    channel_type varchar(128) not null, 
    created_time datetime not null, 
    created_user varchar(64) not null,
    primary key (stream_id)
);

/* Staging */
drop table if exists staging.microservice_twitch_atlas_product;
create table staging.microservice_twitch_atlas_product
(
    product_id int not null auto_increment, 
    product_name nvarchar(128) not null, 
    product_owner nvarchar(128) not null,
    start_time datetime not null,
    end_time datetime not null,
    created_time datetime not null,
    created_user varchar(64) not null,
    primary key (product_id)
);

drop table if exists staging.microservice_twitch_atlas_season;
create table staging.microservice_twitch_atlas_season
(
    season_id int not null auto_increment,
    product_id int not null,
    season_name nvarchar(128) not null,
    start_time datetime not null,
    end_time datetime not null,
    estimated_hours_broadcast float not null,
    prize_pool float not null,
    created_time datetime not null,
    created_user varchar(64) not null,
    primary key (season_id)
);

drop table if exists staging.microservice_twitch_atlas_event;
create table staging.microservice_twitch_atlas_event
(
    event_id int not null auto_increment, 
    season_id int not null,
    product_id int not null,
    event_name nvarchar(128) not null, 
    start_time datetime not null, 
    end_time datetime not null, 
    event_type varchar(128) not null, 
    estimated_ccv int not null, 
    hours_broadcast float not null, 
    created_time datetime not null, 
    created_user varchar(64) not null,
    primary key (event_id)
);

drop table if exists staging.microservice_twitch_atlas_stream;
create table staging.microservice_twitch_atlas_stream
(
    stream_id int not null auto_increment, 
    season_id int not null, 
    event_id int not null,
    product_id int not null, 
    channel_id int not null, 
    stream_login varchar(128) not null, 
    game_name nvarchar(128) not null, 
    start_time datetime not null, 
    end_time datetime not null, 
    channel_type varchar(128) not null, 
    created_time datetime not null, 
    created_user varchar(64) not null,
    primary key (stream_id)
);

/* Production */
drop table if exists production.microservice_twitch_atlas_product;
create table production.microservice_twitch_atlas_product
(
    product_id int not null auto_increment, 
    product_name nvarchar(128) not null, 
    product_owner nvarchar(128) not null,
    start_time datetime not null,
    end_time datetime not null,
    created_time datetime not null,
    created_user varchar(64) not null,
    primary key (product_id)
);

drop table if exists production.microservice_twitch_atlas_season;
create table production.microservice_twitch_atlas_season
(
    season_id int not null auto_increment,
    product_id int not null,
    season_name nvarchar(128) not null,
    start_time datetime not null,
    end_time datetime not null,
    estimated_hours_broadcast float not null,
    prize_pool float not null,
    created_time datetime not null,
    created_user varchar(64) not null,
    primary key (season_id)
);

drop table if exists production.microservice_twitch_atlas_event;
create table production.microservice_twitch_atlas_event
(
    event_id int not null auto_increment, 
    season_id int not null,
    product_id int not null,
    event_name nvarchar(128) not null, 
    start_time datetime not null, 
    end_time datetime not null, 
    event_type varchar(128) not null, 
    estimated_ccv int not null, 
    hours_broadcast float not null, 
    created_time datetime not null, 
    created_user varchar(64) not null,
    primary key (event_id)
);

drop table if exists production.microservice_twitch_atlas_stream;
create table production.microservice_twitch_atlas_stream
(
    stream_id int not null auto_increment, 
    season_id int not null, 
    event_id int not null,
    product_id int not null, 
    channel_id int not null, 
    stream_login varchar(128) not null, 
    game_name nvarchar(128) not null, 
    start_time datetime not null, 
    end_time datetime not null, 
    channel_type varchar(128) not null, 
    created_time datetime not null, 
    created_user varchar(64) not null,
    primary key (stream_id)
);