/* Development */
drop table if exists development.microservice_twitch_atlas_premium_content_creator;
create table development.microservice_twitch_atlas_premium_content_creator
(
    premium_content_creator_id int not null auto_increment,
    premium_content_creator_name nvarchar(128) not null,
    premium_content_creator_type varchar(100) not null,
    account_manager_id_list varchar(500) null,
    is_active boolean not null default true,
    primary key (premium_content_creator_id)
) default character set utf8mb4 collate utf8mb4_general_ci;

drop table if exists development.microservice_twitch_atlas_account_manager;
create table development.microservice_twitch_atlas_account_manager
(
    account_manager_id int not null auto_increment,
    approving_manager_amazon_id nvarchar(100) not null,
    approving_manager_name nvarchar(100) not null,
    primary key (account_manager_id)
);

drop table if exists development.microservice_twitch_atlas_product;
create table development.microservice_twitch_atlas_product
(
    product_id int not null auto_increment, 
    product_name nvarchar(128) not null, 
    product_owner nvarchar(128) not null,
    topic nvarchar(100) null,
    sub_topic nvarchar(100) null,
    format nvarchar(100) null,
    sub_format nvarchar(100) null,
    is_active boolean not null default true,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (product_id)
) default character set utf8mb4 collate utf8mb4_general_ci;

drop table if exists development.microservice_twitch_atlas_season;
create table development.microservice_twitch_atlas_season
(
    season_id int not null auto_increment,
    product_id int null,
    season_name nvarchar(128) not null,
    start_time datetime not null,
    end_time datetime not null,
    pledged_hours_broadcast float null,
    prize_pool float null,
    is_active boolean not null default true,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (season_id)
) default character set utf8mb4 collate utf8mb4_general_ci;

drop table if exists development.microservice_twitch_atlas_event;
create table development.microservice_twitch_atlas_event
(
    event_id int not null auto_increment, 
    season_id int null,
    product_id int null,
    event_name nvarchar(128) not null,
    premium_content_creator_id int not null,
    start_time datetime not null, 
    end_time datetime not null, 
    topic nvarchar(100) null,
    sub_topic nvarchar(100) null,
    format nvarchar(100) null,
    sub_format nvarchar(100) null,
    event_type varchar(128) not null, 
    estimated_average_ccv int null, 
    pledged_hours_broadcast float null, 
    is_active boolean not null default true,
    created_time datetime not null, 
    created_user nvarchar(64) not null,
    primary key (event_id)
) default character set utf8mb4 collate utf8mb4_general_ci;

drop table if exists development.microservice_twitch_atlas_stream;
create table development.microservice_twitch_atlas_stream
(
    stream_id int not null auto_increment, 
    event_id int not null,
    channel_id int not null, 
    stream_login nvarchar(128) not null, 
    game_name nvarchar(128) not null, 
    start_time datetime not null, 
    end_time datetime not null, 
    channel_type varchar(128) not null,
    is_active boolean not null default true,
    created_time datetime not null, 
    created_user nvarchar(64) not null,
    primary key (stream_id)
) default character set utf8mb4 collate utf8mb4_general_ci;

/* Staging */


/* Production */
