/* Development */
drop table if exists development.microservice_twitch_atlas_premium_content_creator;
create table development.microservice_twitch_atlas_premium_content_creator
(
    premium_content_creator_id int not null auto_increment,
    premium_content_creator_name nvarchar(128) not null,
    premium_content_creator_type varchar(100) not null,
    pcc_am_map_id int null,
    is_active boolean not null default true,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    am_name nvarchar(500) null,
    primary key (premium_content_creator_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_premium_content_creator on development.microservice_twitch_atlas_premium_content_creator (premium_content_creator_name);

drop table if exists development.microservice_twitch_atlas_pcc_to_am_map;
create table development.microservice_twitch_atlas_pcc_to_am_map
(
    pcc_am_map_id int not null auto_increment,
    premium_content_creator_id int not null,
    account_manager_id int not null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (pcc_am_map_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_pcc_to_am_map on development.microservice_twitch_atlas_pcc_to_am_map (premium_content_creator_id, account_manager_id);

drop table if exists development.microservice_twitch_atlas_pcc_to_channel_map;
create table development.microservice_twitch_atlas_pcc_to_channel_map
(
    pcc_channel_map_id int not null auto_increment,
    premium_content_creator_id int not null,
    channel_id bigint not null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (pcc_channel_map_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index ux_microservice_twitch_atlas_pcc_to_channel_map on development.microservice_twitch_atlas_pcc_to_channel_map (premium_content_creator_id, channel_id);

drop table if exists development.microservice_twitch_atlas_account_manager;
create table development.microservice_twitch_atlas_account_manager
(
    account_manager_id int not null auto_increment,
    account_manager_ldap_name nvarchar(100) not null,
    account_manager_first_name nvarchar(100) not null,
    account_manager_last_name nvarchar(100) not null,
    account_manager_email nvarchar(100) not null,
    approving_manager_amazon_id nvarchar(100) null,
    approving_manager_name nvarchar(100) null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (account_manager_id)
);
create unique index ux_microservice_twitch_atlas_account_manager on development.microservice_twitch_atlas_account_manager (account_manager_ldap_name);

drop table if exists development.microservice_twitch_atlas_product;
create table development.microservice_twitch_atlas_product
(
    product_id int not null auto_increment, 
    product_name nvarchar(128) not null, 
    product_owner nvarchar(128) not null,
    topic nvarchar(100) null,
    sub_topic nvarchar(100) null,
    format nvarchar(100) null,
    sub_format nvarchar(100) null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (product_id)
) default character set utf8mb4 collate utf8mb4_general_ci;

drop table if exists development.microservice_twitch_atlas_season;
create table development.microservice_twitch_atlas_season
(
    season_id int not null auto_increment,
    product_id int not null,
    season_name nvarchar(128) not null,
    start_time datetime not null,
    end_time datetime not null,
    pledged_hours_broadcast float null,
    prize_pool float null,
    is_active boolean not null default true,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (season_id)
) default character set utf8mb4 collate utf8mb4_general_ci;

drop table if exists development.microservice_twitch_atlas_event;
create table development.microservice_twitch_atlas_event
(
    event_id int not null auto_increment, 
    season_id int null,
    product_id int null,
    event_name nvarchar(128) not null,
    premium_content_creator_id int not null,
    start_time datetime not null, 
    end_time datetime not null, 
    topic nvarchar(100) null,
    sub_topic nvarchar(100) null,
    format nvarchar(100) null,
    sub_format nvarchar(100) null,
    event_type varchar(128) not null, 
    estimated_average_ccv float null, 
    pledged_hours_broadcast float null, 
    is_active boolean not null default true,
    created_time datetime not null, 
    created_user nvarchar(64) not null,
    game_name nvarchar(128) null,
    distribution boolean null,
    twitch_involvement nvarchar(32) null,
    costreaming_settings nvarchar(64) null,
    primary key (event_id)
) default character set utf8mb4 collate utf8mb4_general_ci;

drop table if exists development.microservice_twitch_atlas_stream;
create table development.microservice_twitch_atlas_stream
(
    stream_id int not null auto_increment, 
    event_id int not null,
    channel_id bigint not null, 
    stream_login nvarchar(128) not null, 
    game_name nvarchar(128) null, 
    start_time datetime not null, 
    end_time datetime not null, 
    channel_type varchar(128) not null,
    is_active boolean not null default true,
    created_time datetime not null, 
    created_user nvarchar(64) not null,
    primary key (stream_id)
) default character set utf8mb4 collate utf8mb4_general_ci;

/* Staging */
drop table if exists staging.microservice_twitch_atlas_premium_content_creator;
create table staging.microservice_twitch_atlas_premium_content_creator
(
    premium_content_creator_id int not null auto_increment,
    premium_content_creator_name nvarchar(128) not null,
    premium_content_creator_type varchar(100) not null,
    pcc_am_map_id int null,
    is_active boolean not null default true,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    am_name nvarchar(500) null,
    primary key (premium_content_creator_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_premium_content_creator on staging.microservice_twitch_atlas_premium_content_creator (premium_content_creator_name);
insert into staging.microservice_twitch_atlas_premium_content_creator
select * from development.microservice_twitch_atlas_premium_content_creator
order by premium_content_creator_id;

drop table if exists staging.microservice_twitch_atlas_pcc_to_am_map;
create table staging.microservice_twitch_atlas_pcc_to_am_map
(
    pcc_am_map_id int not null auto_increment,
    premium_content_creator_id int not null,
    account_manager_id int not null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (pcc_am_map_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_pcc_to_am_map on staging.microservice_twitch_atlas_pcc_to_am_map (premium_content_creator_id, account_manager_id);
insert into staging.microservice_twitch_atlas_pcc_to_am_map
select * from development.microservice_twitch_atlas_pcc_to_am_map
order by pcc_am_map_id;


drop table if exists staging.microservice_twitch_atlas_pcc_to_channel_map;
create table staging.microservice_twitch_atlas_pcc_to_channel_map
(
    pcc_channel_map_id int not null auto_increment,
    premium_content_creator_id int not null,
    channel_id bigint not null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (pcc_channel_map_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index ux_microservice_twitch_atlas_pcc_to_channel_map on staging.microservice_twitch_atlas_pcc_to_channel_map (premium_content_creator_id, channel_id);
insert into staging.microservice_twitch_atlas_pcc_to_channel_map
select * from development.microservice_twitch_atlas_pcc_to_channel_map
order by pcc_channel_map_id;

drop table if exists staging.microservice_twitch_atlas_account_manager;
create table staging.microservice_twitch_atlas_account_manager
(
    account_manager_id int not null auto_increment,
    account_manager_ldap_name nvarchar(100) not null,
    account_manager_first_name nvarchar(100) not null,
    account_manager_last_name nvarchar(100) not null,
    account_manager_email nvarchar(100) not null,
    approving_manager_amazon_id nvarchar(100) null,
    approving_manager_name nvarchar(100) null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (account_manager_id)
);
create unique index ux_microservice_twitch_atlas_account_manager on staging.microservice_twitch_atlas_account_manager (account_manager_ldap_name);
insert into staging.microservice_twitch_atlas_account_manager
select * from development.microservice_twitch_atlas_account_manager
order by account_manager_id;

drop table if exists staging.microservice_twitch_atlas_product;
create table staging.microservice_twitch_atlas_product
(
    product_id int not null auto_increment, 
    product_name nvarchar(128) not null, 
    product_owner nvarchar(128) not null,
    topic nvarchar(100) null,
    sub_topic nvarchar(100) null,
    format nvarchar(100) null,
    sub_format nvarchar(100) null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (product_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
insert into staging.microservice_twitch_atlas_product
select * from development.microservice_twitch_atlas_product
order by product_id;

drop table if exists staging.microservice_twitch_atlas_season;
create table staging.microservice_twitch_atlas_season
(
    season_id int not null auto_increment,
    product_id int not null,
    season_name nvarchar(128) not null,
    start_time datetime not null,
    end_time datetime not null,
    pledged_hours_broadcast float null,
    prize_pool float null,
    is_active boolean not null default true,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (season_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
insert into staging.microservice_twitch_atlas_season
select * from development.microservice_twitch_atlas_season
order by season_id;

drop table if exists staging.microservice_twitch_atlas_event;
create table staging.microservice_twitch_atlas_event
(
    event_id int not null auto_increment, 
    season_id int null,
    product_id int null,
    event_name nvarchar(128) not null,
    premium_content_creator_id int not null,
    start_time datetime not null, 
    end_time datetime not null, 
    topic nvarchar(100) null,
    sub_topic nvarchar(100) null,
    format nvarchar(100) null,
    sub_format nvarchar(100) null,
    event_type varchar(128) not null, 
    estimated_average_ccv float null, 
    pledged_hours_broadcast float null, 
    is_active boolean not null default true,
    created_time datetime not null, 
    created_user nvarchar(64) not null,
    game_name nvarchar(128) null,
    distribution boolean null,
    twitch_involvement nvarchar(32) null,
    costreaming_settings nvarchar(64) null,
    primary key (event_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
insert into staging.microservice_twitch_atlas_event
select * from development.microservice_twitch_atlas_event
order by event_id;

drop table if exists staging.microservice_twitch_atlas_stream;
create table staging.microservice_twitch_atlas_stream
(
    stream_id int not null auto_increment, 
    event_id int not null,
    channel_id bigint not null, 
    stream_login nvarchar(128) not null, 
    game_name nvarchar(128) null, 
    start_time datetime not null, 
    end_time datetime not null, 
    channel_type varchar(128) not null,
    is_active boolean not null default true,
    created_time datetime not null, 
    created_user nvarchar(64) not null,
    primary key (stream_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
insert into staging.microservice_twitch_atlas_stream
select * from development.microservice_twitch_atlas_stream
order by stream_id;

/* Production */
drop table if exists production.microservice_twitch_atlas_premium_content_creator;
create table production.microservice_twitch_atlas_premium_content_creator
(
    premium_content_creator_id int not null auto_increment,
    premium_content_creator_name nvarchar(128) not null,
    premium_content_creator_type varchar(100) not null,
    pcc_am_map_id int null,
    is_active boolean not null default true,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    am_name nvarchar(500) null,
    primary key (premium_content_creator_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_premium_content_creator on production.microservice_twitch_atlas_premium_content_creator (premium_content_creator_name);
insert into production.microservice_twitch_atlas_premium_content_creator
select * from development.microservice_twitch_atlas_premium_content_creator
order by premium_content_creator_id;

drop table if exists production.microservice_twitch_atlas_pcc_to_am_map;
create table production.microservice_twitch_atlas_pcc_to_am_map
(
    pcc_am_map_id int not null auto_increment,
    premium_content_creator_id int not null,
    account_manager_id int not null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (pcc_am_map_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_pcc_to_am_map on production.microservice_twitch_atlas_pcc_to_am_map (premium_content_creator_id, account_manager_id);
insert into production.microservice_twitch_atlas_pcc_to_am_map
select * from development.microservice_twitch_atlas_pcc_to_am_map
order by pcc_am_map_id;


drop table if exists production.microservice_twitch_atlas_pcc_to_channel_map;
create table production.microservice_twitch_atlas_pcc_to_channel_map
(
    pcc_channel_map_id int not null auto_increment,
    premium_content_creator_id int not null,
    channel_id bigint not null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (pcc_channel_map_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index ux_microservice_twitch_atlas_pcc_to_channel_map on production.microservice_twitch_atlas_pcc_to_channel_map (premium_content_creator_id, channel_id);
insert into production.microservice_twitch_atlas_pcc_to_channel_map
select * from development.microservice_twitch_atlas_pcc_to_channel_map
order by pcc_channel_map_id;

drop table if exists production.microservice_twitch_atlas_account_manager;
create table production.microservice_twitch_atlas_account_manager
(
    account_manager_id int not null auto_increment,
    account_manager_ldap_name nvarchar(100) not null,
    account_manager_first_name nvarchar(100) not null,
    account_manager_last_name nvarchar(100) not null,
    account_manager_email nvarchar(100) not null,
    approving_manager_amazon_id nvarchar(100) null,
    approving_manager_name nvarchar(100) null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (account_manager_id)
);
create unique index ux_microservice_twitch_atlas_account_manager on production.microservice_twitch_atlas_account_manager (account_manager_ldap_name);
insert into production.microservice_twitch_atlas_account_manager
select * from development.microservice_twitch_atlas_account_manager
order by account_manager_id;

drop table if exists production.microservice_twitch_atlas_product;
create table production.microservice_twitch_atlas_product
(
    product_id int not null auto_increment, 
    product_name nvarchar(128) not null, 
    product_owner nvarchar(128) not null,
    topic nvarchar(100) null,
    sub_topic nvarchar(100) null,
    format nvarchar(100) null,
    sub_format nvarchar(100) null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (product_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
insert into production.microservice_twitch_atlas_product
select * from development.microservice_twitch_atlas_product
order by product_id;

drop table if exists production.microservice_twitch_atlas_season;
create table production.microservice_twitch_atlas_season
(
    season_id int not null auto_increment,
    product_id int not null,
    season_name nvarchar(128) not null,
    start_time datetime not null,
    end_time datetime not null,
    pledged_hours_broadcast float null,
    prize_pool float null,
    is_active boolean not null default true,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (season_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
insert into production.microservice_twitch_atlas_season
select * from development.microservice_twitch_atlas_season
order by season_id;

drop table if exists production.microservice_twitch_atlas_event;
create table production.microservice_twitch_atlas_event
(
    event_id int not null auto_increment, 
    season_id int null,
    product_id int null,
    event_name nvarchar(128) not null,
    premium_content_creator_id int not null,
    start_time datetime not null, 
    end_time datetime not null, 
    topic nvarchar(100) null,
    sub_topic nvarchar(100) null,
    format nvarchar(100) null,
    sub_format nvarchar(100) null,
    event_type varchar(128) not null, 
    estimated_average_ccv float null, 
    pledged_hours_broadcast float null, 
    is_active boolean not null default true,
    created_time datetime not null, 
    created_user nvarchar(64) not null,
    game_name nvarchar(128) null,
    distribution boolean null,
    twitch_involvement nvarchar(32) null,
    costreaming_settings nvarchar(64) null,
    primary key (event_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
insert into production.microservice_twitch_atlas_event
select * from development.microservice_twitch_atlas_event
order by event_id;

drop table if exists production.microservice_twitch_atlas_stream;
create table production.microservice_twitch_atlas_stream
(
    stream_id int not null auto_increment, 
    event_id int not null,
    channel_id bigint not null, 
    stream_login nvarchar(128) not null, 
    game_name nvarchar(128) null, 
    start_time datetime not null, 
    end_time datetime not null, 
    channel_type varchar(128) not null,
    is_active boolean not null default true,
    created_time datetime not null, 
    created_user nvarchar(64) not null,
    primary key (stream_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
insert into production.microservice_twitch_atlas_stream
select * from development.microservice_twitch_atlas_stream
order by stream_id;