/* Development */
drop table if exists development.microservice_twitch_atlas_event;
create table development.microservice_twitch_atlas_event
(
    event_id int not null auto_increment, 
    season_id int null,
    product_id int null,
    event_name nvarchar(128) not null,
    premium_content_creator_id int not null,
    start_time datetime not null, 
    end_time datetime not null, 
    topic nvarchar(100) null,
    sub_topic nvarchar(100) null,
    format nvarchar(100) null,
    sub_format nvarchar(100) null,
    event_type varchar(128) not null, 
    estimated_average_ccv float null, 
    pledged_hours_broadcast float null, 
    is_active boolean not null default true,
    created_time datetime not null, 
    created_user nvarchar(64) not null,
    hash nvarchar(100) not null,
    game_name nvarchar(128) null,
    distribution boolean null,
    twitch_involvement nvarchar(32) null,
    costreaming_settings nvarchar(64) null,
    updated_time datetime null,
    updated_user nvarchar(64),
    primary key (event_id)
) default character set utf8mb4 collate utf8mb4_general_ci;

/* Staging */
drop table if exists staging.microservice_twitch_atlas_event;
create table staging.microservice_twitch_atlas_event
(
    event_id int not null auto_increment, 
    season_id int null,
    product_id int null,
    event_name nvarchar(128) not null,
    premium_content_creator_id int not null,
    start_time datetime not null, 
    end_time datetime not null, 
    topic nvarchar(100) null,
    sub_topic nvarchar(100) null,
    format nvarchar(100) null,
    sub_format nvarchar(100) null,
    event_type varchar(128) not null, 
    estimated_average_ccv float null, 
    pledged_hours_broadcast float null, 
    is_active boolean not null default true,
    created_time datetime not null, 
    created_user nvarchar(64) not null,
    hash nvarchar(100) not null,
    game_name nvarchar(128) null,
    distribution boolean null,
    twitch_involvement nvarchar(32) null,
    costreaming_settings nvarchar(64) null,
    updated_time datetime null,
    updated_user nvarchar(64),
    primary key (event_id)
) default character set utf8mb4 collate utf8mb4_general_ci;

/* Production */
drop table if exists production.microservice_twitch_atlas_event;
create table production.microservice_twitch_atlas_event
(
    event_id int not null auto_increment, 
    season_id int null,
    product_id int null,
    event_name nvarchar(128) not null,
    premium_content_creator_id int not null,
    start_time datetime not null, 
    end_time datetime not null, 
    topic nvarchar(100) null,
    sub_topic nvarchar(100) null,
    format nvarchar(100) null,
    sub_format nvarchar(100) null,
    event_type varchar(128) not null, 
    estimated_average_ccv float null, 
    pledged_hours_broadcast float null, 
    is_active boolean not null default true,
    created_time datetime not null, 
    created_user nvarchar(64) not null,
    hash nvarchar(100) not null,
    game_name nvarchar(128) null,
    distribution boolean null,
    twitch_involvement nvarchar(32) null,
    costreaming_settings nvarchar(64) null,
    updated_time datetime null,
    updated_user nvarchar(64),
    primary key (event_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
insert into production.microservice_twitch_atlas_event
select * from development.microservice_twitch_atlas_event
order by event_id;