/* Development */
drop table if exists development.microservice_twitch_atlas_formats;
create table development.microservice_twitch_atlas_formats
(
    format_auto_id int not null auto_increment,
    format_id int not null,
    topic_id int not null,
    format_name nvarchar(100) not null,
    format_description nvarchar(500) null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (format_auto_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create index ix_microservice_twitch_atlas_formats on development.microservice_twitch_atlas_formats (format_id);

/* Staging */
drop table if exists staging.microservice_twitch_atlas_formats;
create table staging.microservice_twitch_atlas_formats
(
    format_auto_id int not null auto_increment,
    format_id int not null,
    topic_id int not null,
    format_name nvarchar(100) not null,
    format_description nvarchar(500) null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (format_auto_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create index ix_microservice_twitch_atlas_formats on staging.microservice_twitch_atlas_formats (format_id);
insert into staging.microservice_twitch_atlas_formats
select * from development.microservice_twitch_atlas_formats
order by format_id;

/* Production */
drop table if exists production.microservice_twitch_atlas_formats;
create table production.microservice_twitch_atlas_formats
(
    format_auto_id int not null auto_increment,
    format_id int not null,
    topic_id int not null,
    format_name nvarchar(100) not null,
    format_description nvarchar(500) null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (format_auto_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create index ix_microservice_twitch_atlas_formats on production.microservice_twitch_atlas_formats (format_id);
insert into production.microservice_twitch_atlas_formats
select * from development.microservice_twitch_atlas_formats
order by format_id;