/* Development */
drop table if exists development.microservice_twitch_atlas_pcc_to_am_map;
create table development.microservice_twitch_atlas_pcc_to_am_map
(
    pcc_am_map_id int not null auto_increment,
    premium_content_creator_id int not null,
    account_manager_id int not null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    hash nvarchar(100) not null,
    primary key (pcc_am_map_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_pcc_to_am_map on development.microservice_twitch_atlas_pcc_to_am_map (premium_content_creator_id, account_manager_id);

/* Staging */
drop table if exists staging.microservice_twitch_atlas_pcc_to_am_map;
create table staging.microservice_twitch_atlas_pcc_to_am_map
(
    pcc_am_map_id int not null auto_increment,
    premium_content_creator_id int not null,
    account_manager_id int not null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    hash nvarchar(100) not null,
    primary key (pcc_am_map_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_pcc_to_am_map on staging.microservice_twitch_atlas_pcc_to_am_map (premium_content_creator_id, account_manager_id);

/* Production */
drop table if exists production.microservice_twitch_atlas_pcc_to_am_map;
create table production.microservice_twitch_atlas_pcc_to_am_map
(
    pcc_am_map_id int not null auto_increment,
    premium_content_creator_id int not null,
    account_manager_id int not null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    hash nvarchar(100) not null,
    primary key (pcc_am_map_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_pcc_to_am_map on production.microservice_twitch_atlas_pcc_to_am_map (premium_content_creator_id, account_manager_id);