/* Development */
drop table if exists development.microservice_twitch_atlas_premium_content_creator;
create table development.microservice_twitch_atlas_premium_content_creator
(
    premium_content_creator_id int not null auto_increment,
    premium_content_creator_name nvarchar(128) not null,
    premium_content_creator_type varchar(100) not null,
    is_active boolean not null default true,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    am_name nvarchar(500) null,
    hash nvarchar(100) not null,
    primary key (premium_content_creator_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_premium_content_creator on development.microservice_twitch_atlas_premium_content_creator (premium_content_creator_name);

/* Staging */
drop table if exists staging.microservice_twitch_atlas_premium_content_creator;
create table staging.microservice_twitch_atlas_premium_content_creator
(
    premium_content_creator_id int not null auto_increment,
    premium_content_creator_name nvarchar(128) not null,
    premium_content_creator_type varchar(100) not null,
    is_active boolean not null default true,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    am_name nvarchar(500) null,
    hash nvarchar(100) not null,
    primary key (premium_content_creator_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_premium_content_creator on staging.microservice_twitch_atlas_premium_content_creator (premium_content_creator_name);

/* Production */
drop table if exists production.microservice_twitch_atlas_premium_content_creator;
create table production.microservice_twitch_atlas_premium_content_creator
(
    premium_content_creator_id int not null auto_increment,
    premium_content_creator_name nvarchar(128) not null,
    premium_content_creator_type varchar(100) not null,
    is_active boolean not null default true,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    am_name nvarchar(500) null,
    hash nvarchar(100) not null,
    primary key (premium_content_creator_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_premium_content_creator on production.microservice_twitch_atlas_premium_content_creator (premium_content_creator_name);
