/* 
* V1 script is destructive by default. Execute with caution
* Timeseries nomenclature: timeseries {aggregation level} {content type} 
*/
drop table if exists development.microservice_twitch_timeseries_daily_channel_pcc_dashboard;
create table development.microservice_twitch_timeseries_daily_channel_pcc_dashboard
(
    /* Basic identifier fields */
    id varchar(64) not null,
    `date` date not null,
    premium_content_creator_id bigint not null,
    product_id int null,
    season_id int null,
    event_id int null
    /* Custom Stat Fields */
    hours_watched float not null,
    hours_watched_live float not null,
    hours_watched_vod float not null,
    event_duration_minutes float not null,
    event_views bigint not null,
    event_channel_views bigint not null,
    peak_ccv int not null,
    average_minute_audience float not null,
    average_view_duration float not null,
    /* Tracking metadata */
    created_by nvarchar(100) not null,
    created_date datetime not null,
    created_transaction_id varchar(64) not null,
    last_modified_by nvarchar(100) not null,
    last_modified_date datetime not null,
    last_modified_transaction_id varchar(64) not null,
    rowhash nvarchar(100) not null,
    hash nvarchar(100) not null,
    primary key (id)
) default character set utf8mb4 collate utf8mb4_general_ci;

create index ix_timeseries_daily_channel_pcc_dashboard_pcc_channel
on development.microservice_twitch_timeseries_daily_channel_pcc_dashboard 
(`premium_content_creator_id`, `event_id`);

create unique index uix_timeseries_daily_channel_pcc_dashboard_compound
on development.microservice_twitch_timeseries_daily_channel_pcc_dashboard 
(`date`, `premium_content_creator_id`, `product_id`, `season_id`, `event_id`);