/* Development */
drop table if exists development.microservice_twitch_atlas_product;
create table development.microservice_twitch_atlas_product
(
    product_id int not null auto_increment, 
    product_name nvarchar(128) not null,
    product_description nvarchar(500) null,
    product_owner nvarchar(128) not null,
    topic nvarchar(100) null,
    sub_topic nvarchar(100) null,
    format nvarchar(100) null,
    sub_format nvarchar(100) null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (product_id)
) default character set utf8mb4 collate utf8mb4_general_ci;

/* Staging */
drop table if exists staging.microservice_twitch_atlas_product;
create table staging.microservice_twitch_atlas_product
(
    product_id int not null auto_increment, 
    product_name nvarchar(128) not null, 
    product_description nvarchar(500) null,
    product_owner nvarchar(128) not null,
    topic nvarchar(100) null,
    sub_topic nvarchar(100) null,
    format nvarchar(100) null,
    sub_format nvarchar(100) null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (product_id)
) default character set utf8mb4 collate utf8mb4_general_ci;

/* Production */
drop table if exists production.microservice_twitch_atlas_product;
create table production.microservice_twitch_atlas_product
(
    product_id int not null auto_increment, 
    product_name nvarchar(128) not null, 
    product_description nvarchar(500) null,
    product_owner nvarchar(128) not null,
    topic nvarchar(100) null,
    sub_topic nvarchar(100) null,
    format nvarchar(100) null,
    sub_format nvarchar(100) null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (product_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
