/* Development */
drop table if exists development.microservice_twitch_atlas_season;
create table development.microservice_twitch_atlas_season
(
    season_id int not null auto_increment,
    product_id int not null,
    season_name nvarchar(128) not null,
    start_time datetime not null,
    end_time datetime not null,
    pledged_hours_broadcast float null,
    prize_pool float null,
    is_active boolean not null default true,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    previous_season_id int null,
    previous_season_name nvarchar(128) null,
    primary key (season_id)
) default character set utf8mb4 collate utf8mb4_general_ci;

/* Staging */
drop table if exists staging.microservice_twitch_atlas_season;
create table staging.microservice_twitch_atlas_season
(
    season_id int not null auto_increment,
    product_id int not null,
    season_name nvarchar(128) not null,
    start_time datetime not null,
    end_time datetime not null,
    pledged_hours_broadcast float null,
    prize_pool float null,
    is_active boolean not null default true,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    previous_season_id int null,
    previous_season_name nvarchar(128) null,
    primary key (season_id)
) default character set utf8mb4 collate utf8mb4_general_ci;

/* Production */
drop table if exists production.microservice_twitch_atlas_season;
create table production.microservice_twitch_atlas_season
(
    season_id int not null auto_increment,
    product_id int not null,
    season_name nvarchar(128) not null,
    start_time datetime not null,
    end_time datetime not null,
    pledged_hours_broadcast float null,
    prize_pool float null,
    is_active boolean not null default true,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    previous_season_id int null,
    previous_season_name nvarchar(128) null,
    primary key (season_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
