/* Development */
drop table if exists development.staging_microservice_twitch_atlas_channel_summary;
create table development.staging_microservice_twitch_atlas_channel_summary
(
    premium_content_creator_id int not null,
    channel_id bigint not null,
    day datetime not null,
    daily_total_minutes_watched float not null,
    daily_total_minutes_broadcast float not null,
    creator_revenue_total float not null,
    ad_revenue_total float not null,
    sub_revenue_total float not null,
    bits_revenue_total float not null,
    fuel_revenue_total float not null,
    bounty_board_revenue_total float not null,
    hash nvarchar(100) not null,
    primary key (premium_content_creator_id, channel_id, day)
);

/* Staging */
drop table if exists staging.staging_microservice_twitch_atlas_channel_summary;
create table staging.staging_microservice_twitch_atlas_channel_summary
(
    premium_content_creator_id int not null,
    channel_id bigint not null,
    day datetime not null,
    daily_total_minutes_watched float not null,
    daily_total_minutes_broadcast float not null,
    creator_revenue_total float not null,
    ad_revenue_total float not null,
    sub_revenue_total float not null,
    bits_revenue_total float not null,
    fuel_revenue_total float not null,
    bounty_board_revenue_total float not null,
    hash nvarchar(100) not null,
    primary key (premium_content_creator_id, channel_id, day)
);

/* Production */
drop table if exists production.staging_microservice_twitch_atlas_channel_summary;
create table production.staging_microservice_twitch_atlas_channel_summary
(
    premium_content_creator_id int not null,
    channel_id bigint not null,
    day datetime not null,
    daily_total_minutes_watched float not null,
    daily_total_minutes_broadcast float not null,
    creator_revenue_total float not null,
    ad_revenue_total float not null,
    sub_revenue_total float not null,
    bits_revenue_total float not null,
    fuel_revenue_total float not null,
    bounty_board_revenue_total float not null,
    hash nvarchar(100) not null,
    primary key (premium_content_creator_id, channel_id, day)
);