/* Development */
drop table if exists development.microservice_twitch_atlas_stream;
create table development.microservice_twitch_atlas_stream
(
    stream_id int not null auto_increment, 
    event_id int not null,
    channel_id bigint not null, 
    stream_login nvarchar(128) not null, 
    game_name nvarchar(128) null, 
    start_time datetime not null, 
    end_time datetime not null, 
    channel_type varchar(128) not null,
    is_active boolean not null default true,
    created_time datetime not null, 
    created_user nvarchar(64) not null,
    primary key (stream_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_stream on development.microservice_twitch_atlas_stream (event_id, channel_id);

/* Staging */
drop table if exists staging.microservice_twitch_atlas_stream;
create table staging.microservice_twitch_atlas_stream
(
    stream_id int not null auto_increment, 
    event_id int not null,
    channel_id bigint not null, 
    stream_login nvarchar(128) not null, 
    game_name nvarchar(128) null, 
    start_time datetime not null, 
    end_time datetime not null, 
    channel_type varchar(128) not null,
    is_active boolean not null default true,
    created_time datetime not null, 
    created_user nvarchar(64) not null,
    primary key (stream_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_stream on staging.microservice_twitch_atlas_stream (event_id, channel_id);

/* Production */
drop table if exists production.microservice_twitch_atlas_stream;
create table production.microservice_twitch_atlas_stream
(
    stream_id int not null auto_increment, 
    event_id int not null,
    channel_id bigint not null, 
    stream_login nvarchar(128) not null, 
    game_name nvarchar(128) null, 
    start_time datetime not null, 
    end_time datetime not null, 
    channel_type varchar(128) not null,
    is_active boolean not null default true,
    created_time datetime not null, 
    created_user nvarchar(64) not null,
    primary key (stream_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_stream on production.microservice_twitch_atlas_stream (event_id, channel_id);
