/* Development */
drop table if exists development.microservice_twitch_atlas_sub_formats;
create table development.microservice_twitch_atlas_sub_formats
(
	sub_format_auto_id int not null auto_increment,
    sub_format_id int not null,
    format_id int not null,
    sub_format_name nvarchar(100) not null,
    sub_format_description nvarchar(500) null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64),
    hash nvarchar(100) not null,
    primary key (sub_format_auto_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create index ix_microservice_twitch_atlas_sub_formats on development.microservice_twitch_atlas_sub_formats (format_id, sub_format_id);

/* Staging */
drop table if exists staging.microservice_twitch_atlas_sub_formats;
create table staging.microservice_twitch_atlas_sub_formats
(
	sub_format_auto_id int not null auto_increment,
    sub_format_id int not null,
    format_id int not null,
    sub_format_name nvarchar(100) not null,
    sub_format_description nvarchar(500) null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64),
    hash nvarchar(100) not null,
    primary key (sub_format_auto_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create index ix_microservice_twitch_atlas_sub_formats on staging.microservice_twitch_atlas_sub_formats (sub_format_id);
insert into staging.microservice_twitch_atlas_sub_formats
select * from development.microservice_twitch_atlas_sub_formats 
order by sub_format_id;

/* Production */
drop table if exists production.microservice_twitch_atlas_sub_formats;
create table production.microservice_twitch_atlas_sub_formats
(
	sub_format_auto_id int not null auto_increment,
    sub_format_id int not null,
    format_id int not null,
    sub_format_name nvarchar(100) not null,
    sub_format_description nvarchar(500) null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64),
    hash nvarchar(100) not null,
    primary key (sub_format_auto_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create index ix_microservice_twitch_atlas_sub_formats on production.microservice_twitch_atlas_sub_formats (sub_format_id);
insert into production.microservice_twitch_atlas_sub_formats
select * from development.microservice_twitch_atlas_sub_formats 
order by sub_format_id;