/* Development */
drop table if exists development.microservice_twitch_atlas_sub_topics;
create table development.microservice_twitch_atlas_sub_topics
(
    sub_topic_auto_id int not null auto_increment,
    sub_topic_id int not null,
    topic_id int not null,
    sub_topic_name nvarchar(100) not null,
    sub_topic_description nvarchar(500) null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (sub_topic_auto_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_sub_topics on development.microservice_twitch_atlas_sub_topics (topic_id, sub_topic_id);
create index ix_microservice_twitch_atlas_sub_topics on development.microservice_twitch_atlas_sub_topics (sub_topic_name);

/* Staging */
drop table if exists staging.microservice_twitch_atlas_sub_topics;
create table staging.microservice_twitch_atlas_sub_topics
(
    sub_topic_auto_id int not null auto_increment,
    sub_topic_id int not null,
    topic_id int not null,
    sub_topic_name nvarchar(100) not null,
    sub_topic_description nvarchar(500) null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (sub_topic_auto_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_sub_topics on staging.microservice_twitch_atlas_sub_topics (topic_id, sub_topic_id);
create index ix_microservice_twitch_atlas_sub_topics on staging.microservice_twitch_atlas_sub_topics (sub_topic_name);
insert into staging.microservice_twitch_atlas_sub_topics
select * from development.microservice_twitch_atlas_sub_topics
order by sub_topic_auto_id;

/* Production */
drop table if exists production.microservice_twitch_atlas_sub_topics;
create table production.microservice_twitch_atlas_sub_topics
(
    sub_topic_auto_id int not null auto_increment,
    sub_topic_id int not null,
    topic_id int not null,
    sub_topic_name nvarchar(100) not null,
    sub_topic_description nvarchar(500) null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (sub_topic_auto_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_sub_topics on production.microservice_twitch_atlas_sub_topics (topic_id, sub_topic_id);
create index ix_microservice_twitch_atlas_sub_topics on production.microservice_twitch_atlas_sub_topics (sub_topic_name);
insert into production.microservice_twitch_atlas_sub_topics
select * from development.microservice_twitch_atlas_sub_topics
order by sub_topic_auto_id;