/* Development */
drop table if exists development.microservice_twitch_atlas_topics;
create table development.microservice_twitch_atlas_topics
(
    topic_auto_id int not null auto_increment,
    topic_id int not null,
    topic_name nvarchar(100) not null,
    topic_description nvarchar(500) null,
    is_gaming boolean not null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (topic_auto_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_topics on development.microservice_twitch_atlas_topics (topic_id);
create index ix_microservice_twitch_atlas_topics on development.microservice_twitch_atlas_topics (topic_name);

/* Staging */
drop table if exists staging.microservice_twitch_atlas_topics;
create table staging.microservice_twitch_atlas_topics
(
    topic_auto_id int not null auto_increment,
    topic_id int not null,
    topic_name nvarchar(100) not null,
    topic_description nvarchar(500) null,
    is_gaming boolean not null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (topic_auto_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_topics on staging.microservice_twitch_atlas_topics (topic_id);
create index ix_microservice_twitch_atlas_topics on staging.microservice_twitch_atlas_topics (topic_name);
insert into staging.microservice_twitch_atlas_topics
select * from development.microservice_twitch_atlas_topics
order by topic_id;

/* Production */
drop table if exists production.microservice_twitch_atlas_topics;
create table production.microservice_twitch_atlas_topics
(
    topic_auto_id int not null auto_increment,
    topic_id int not null,
    topic_name nvarchar(100) not null,
    topic_description nvarchar(500) null,
    is_gaming boolean not null,
    is_active boolean not null,
    created_time datetime not null,
    created_user nvarchar(64) not null,
    primary key (topic_auto_id)
) default character set utf8mb4 collate utf8mb4_general_ci;
create unique index uix_microservice_twitch_atlas_topics on production.microservice_twitch_atlas_topics (topic_id);
create index ix_microservice_twitch_atlas_topics on production.microservice_twitch_atlas_topics (topic_name);
insert into production.microservice_twitch_atlas_topics
select * from development.microservice_twitch_atlas_topics
order by topic_id;