/* Development */
create or replace view development.vw_atlas_pcc_to_am_map
as
select
    a.premium_content_creator_id,
    a.premium_content_creator_name,
    a.premium_content_creator_type,
    a.created_time as pcc_created_time,
    a.created_user as pcc_created_user,
    b.pcc_am_map_id,
    c.account_manager_id,
    c.account_manager_ldap_name,
    c.account_manager_first_name,
    c.account_manager_last_name,
    c.approving_manager_amazon_id,
    c.approving_manager_name,
    c.created_time as am_created_time,
    c.created_user as am_created_user,
    case when a.is_active = true and b.is_active = true and c.is_active = true then true else false end as is_active
from development.microservice_twitch_atlas_premium_content_creator as a
left join development.microservice_twitch_atlas_pcc_to_am_map as b
    on a.premium_content_creator_id = b.premium_content_creator_id
left join development.microservice_twitch_atlas_account_manager as c
    on b.account_manager_id = c.account_manager_id
;

/* Staging */
create or replace view staging.vw_atlas_pcc_to_am_map
as
select
    a.premium_content_creator_id,
    a.premium_content_creator_name,
    a.premium_content_creator_type,
    a.created_time as pcc_created_time,
    a.created_user as pcc_created_user,
    b.pcc_am_map_id,
    c.account_manager_id,
    c.account_manager_ldap_name,
    c.account_manager_first_name,
    c.account_manager_last_name,
    c.approving_manager_amazon_id,
    c.approving_manager_name,
    c.created_time as am_created_time,
    c.created_user as am_created_user,
    case when a.is_active = true and b.is_active = true and c.is_active = true then true else false end as is_active
from staging.microservice_twitch_atlas_premium_content_creator as a
left join staging.microservice_twitch_atlas_pcc_to_am_map as b
    on a.premium_content_creator_id = b.premium_content_creator_id
left join staging.microservice_twitch_atlas_account_manager as c
    on b.account_manager_id = c.account_manager_id
;

/* Production */
create or replace view production.vw_atlas_pcc_to_am_map
as
select
    a.premium_content_creator_id,
    a.premium_content_creator_name,
    a.premium_content_creator_type,
    a.created_time as pcc_created_time,
    a.created_user as pcc_created_user,
    b.pcc_am_map_id,
    c.account_manager_id,
    c.account_manager_ldap_name,
    c.account_manager_first_name,
    c.account_manager_last_name,
    c.approving_manager_amazon_id,
    c.approving_manager_name,
    c.created_time as am_created_time,
    c.created_user as am_created_user,
    case when a.is_active = true and b.is_active = true and c.is_active = true then true else false end as is_active
from production.microservice_twitch_atlas_premium_content_creator as a
left join production.microservice_twitch_atlas_pcc_to_am_map as b
    on a.premium_content_creator_id = b.premium_content_creator_id
left join production.microservice_twitch_atlas_account_manager as c
    on b.account_manager_id = c.account_manager_id
;