/* Development */
create or replace view development.vw_atlas_pcc_to_channel_map
as
select
    a.premium_content_creator_id,
    a.premium_content_creator_name,
    a.premium_content_creator_type,
    a.created_time as pcc_created_time,
    a.created_user as pcc_created_user,
    b.pcc_channel_map_id,
    b.channel_id,
    case when a.is_active = true and b.is_active = true then true else false end as is_active
from development.microservice_twitch_atlas_premium_content_creator as a
left join development.microservice_twitch_atlas_pcc_to_channel_map as b
    on a.premium_content_creator_id = b.premium_content_creator_id
;

/* Staging */
create or replace view staging.vw_atlas_pcc_to_channel_map
as
select
    a.premium_content_creator_id,
    a.premium_content_creator_name,
    a.premium_content_creator_type,
    a.created_time as pcc_created_time,
    a.created_user as pcc_created_user,
    b.pcc_channel_map_id,
    b.channel_id,
    case when a.is_active = true and b.is_active = true then true else false end as is_active
from staging.microservice_twitch_atlas_premium_content_creator as a
left join staging.microservice_twitch_atlas_pcc_to_channel_map as b
    on a.premium_content_creator_id = b.premium_content_creator_id
;

/* Production */
create or replace view production.vw_atlas_pcc_to_channel_map
as
select
    a.premium_content_creator_id,
    a.premium_content_creator_name,
    a.premium_content_creator_type,
    a.created_time as pcc_created_time,
    a.created_user as pcc_created_user,
    b.pcc_channel_map_id,
    b.channel_id,
    case when a.is_active = true and b.is_active = true then true else false end as is_active
from production.microservice_twitch_atlas_premium_content_creator as a
left join production.microservice_twitch_atlas_pcc_to_channel_map as b
    on a.premium_content_creator_id = b.premium_content_creator_id
;