/* Development */
create or replace view development.vw_atlas_premium_content_creator
as
select
	premium_content_creator_id,
    premium_content_creator_name,
    premium_content_creator_type,
    is_active,
    created_time,
    created_user,
    (select count(*) from development.microservice_twitch_atlas_pcc_to_channel_map as b where a.premium_content_creator_id = b.premium_content_creator_id and is_active = true) as count_of_owned_channels,
    (select count(*) from development.microservice_twitch_atlas_event as c where a.premium_content_creator_id = c.premium_content_creator_id and c.is_active = true and c.start_time >= utc_date() and c.start_time <= date_add(utc_date(), interval 30 day)) as count_of_upcoming_events
from development.microservice_twitch_atlas_premium_content_creator as a
;

/* Staging */
create or replace view staging.vw_atlas_premium_content_creator
as
select
	premium_content_creator_id,
    premium_content_creator_name,
    premium_content_creator_type,
    is_active,
    created_time,
    created_user,
    (select count(*) from staging.microservice_twitch_atlas_pcc_to_channel_map as b where a.premium_content_creator_id = b.premium_content_creator_id and is_active = true) as count_of_owned_channels,
    (select count(*) from staging.microservice_twitch_atlas_event as c where a.premium_content_creator_id = c.premium_content_creator_id and c.is_active = true and c.start_time >= utc_date() and c.start_time <= date_add(utc_date(), interval 30 day)) as count_of_upcoming_events
from staging.microservice_twitch_atlas_premium_content_creator as a
;

/* Production */
create or replace view production.vw_atlas_premium_content_creator
as
select
	premium_content_creator_id,
    premium_content_creator_name,
    premium_content_creator_type,
    is_active,
    created_time,
    created_user,
    (select count(*) from production.microservice_twitch_atlas_pcc_to_channel_map as b where a.premium_content_creator_id = b.premium_content_creator_id and is_active = true) as count_of_owned_channels,
    (select count(*) from production.microservice_twitch_atlas_event as c where a.premium_content_creator_id = c.premium_content_creator_id and c.is_active = true and c.start_time >= utc_date() and c.start_time <= date_add(utc_date(), interval 30 day)) as count_of_upcoming_events
from production.microservice_twitch_atlas_premium_content_creator as a
;
