/* Development */
create or replace view development.vw_atlas_product_details
as
select
	product_id,
    product_name,
    product_description,
    product_owner,
    topic,
    sub_topic,
    format,
    sub_format,
    is_active,
    (
		select count(*) 
        from development.microservice_twitch_atlas_event as b
        inner join development.microservice_twitch_atlas_stream as c
			on b.event_id = c.event_id
		where a.product_id = b.product_id
        and b.is_active = true
        and c.is_active = true
	) as count_of_channels,
    (
		select count(*) 
        from development.microservice_twitch_atlas_event as c 
        where a.product_id = c.product_id 
        and c.is_active = true 
        and c.start_time >= utc_date() 
        and c.start_time <= date_add(utc_date(), interval 30 day)
	) as count_of_upcoming_events
from
	development.microservice_twitch_atlas_product as a
;

/* Staging */
create or replace view staging.vw_atlas_product_details
as
select
	product_id,
    product_name,
    product_description,
    product_owner,
    topic,
    sub_topic,
    format,
    sub_format,
    is_active,
    (
		select count(*) 
        from staging.microservice_twitch_atlas_event as b
        inner join staging.microservice_twitch_atlas_stream as c
			on b.event_id = c.event_id
		where a.product_id = b.product_id
        and b.is_active = true
        and c.is_active = true
	) as count_of_channels,
    (
		select count(*) 
        from staging.microservice_twitch_atlas_event as c 
        where a.product_id = c.product_id 
        and c.is_active = true 
        and c.start_time >= utc_date() 
        and c.start_time <= date_add(utc_date(), interval 30 day)
	) as count_of_upcoming_events
from
	staging.microservice_twitch_atlas_product as a
;

/* Production */
create or replace view production.vw_atlas_product_details
as
select
	product_id,
    product_name,
    product_description,
    product_owner,
    topic,
    sub_topic,
    format,
    sub_format,
    is_active,
    (
		select count(*) 
        from production.microservice_twitch_atlas_event as b
        inner join production.microservice_twitch_atlas_stream as c
			on b.event_id = c.event_id
		where a.product_id = b.product_id
        and b.is_active = true
        and c.is_active = true
	) as count_of_channels,
    (
		select count(*) 
        from production.microservice_twitch_atlas_event as c 
        where a.product_id = c.product_id 
        and c.is_active = true 
        and c.start_time >= utc_date() 
        and c.start_time <= date_add(utc_date(), interval 30 day)
	) as count_of_upcoming_events
from
	production.microservice_twitch_atlas_product as a
;