/* Development */
create or replace view development.vw_atlas_product_details
as
select
	a.product_id,
    a.product_name,
    a.product_description,
    a.product_owner,
    a.topic,
    a.sub_topic,
    a.format,
    a.sub_format,
    a.is_active,
    a.contract_id,
    (
		select count(*) 
        from development.microservice_twitch_atlas_event as b
        inner join development.microservice_twitch_atlas_stream as c
			on b.event_id = c.event_id
		where a.product_id = b.product_id
	) as count_of_channels,
    (
		select count(*) 
        from development.microservice_twitch_atlas_event as c 
        where a.product_id = c.product_id 
        and c.start_time >= utc_date() 
        and c.start_time <= date_add(utc_date(), interval 30 day)
	) as count_of_upcoming_events,
    a.premium_content_creator_id,
    case 
		when fp.product_id is not null 
        then concat('https://assets.atlas.xarth.tv/D/', a.product_id, '/images/', fp.asset_location, '/', fp.asset_id, '.', fp.asset_file_type)
    else null end as front_page_asset
from
	development.microservice_twitch_atlas_product as a
left join development.microservice_twitch_atlas_product_assets as fp
	on a.product_id = fp.product_id
    and fp.asset_location = 'front-page-promotional-banner-slot'
;

/* Staging */
create or replace view staging.vw_atlas_product_details
as
select
	a.product_id,
    a.product_name,
    a.product_description,
    a.product_owner,
    a.topic,
    a.sub_topic,
    a.format,
    a.sub_format,
    a.is_active,
    a.contract_id,
    (
		select count(*) 
        from staging.microservice_twitch_atlas_event as b
        inner join staging.microservice_twitch_atlas_stream as c
			on b.event_id = c.event_id
		where a.product_id = b.product_id
	) as count_of_channels,
    (
		select count(*) 
        from staging.microservice_twitch_atlas_event as c 
        where a.product_id = c.product_id 
        and c.start_time >= utc_date() 
        and c.start_time <= date_add(utc_date(), interval 30 day)
	) as count_of_upcoming_events,
    a.premium_content_creator_id,
    case 
		when fp.product_id is not null 
        then concat('https://assets.atlas.xarth.tv/S/', a.product_id, '/images/', fp.asset_location, '/', fp.asset_id, '.', fp.asset_file_type)
    else null end as front_page_asset
from
	staging.microservice_twitch_atlas_product as a
left join staging.microservice_twitch_atlas_product_assets as fp
	on a.product_id = fp.product_id
    and fp.asset_location = 'front-page-promotional-banner-slot'
;

/* Production */
create or replace view production.vw_atlas_product_details
as
select
	a.product_id,
    a.product_name,
    a.product_description,
    a.product_owner,
    a.topic,
    a.sub_topic,
    a.format,
    a.sub_format,
    a.is_active,
    a.contract_id,
    (
		select count(*) 
        from production.microservice_twitch_atlas_event as b
        inner join production.microservice_twitch_atlas_stream as c
			on b.event_id = c.event_id
		where a.product_id = b.product_id
	) as count_of_channels,
    (
		select count(*) 
        from production.microservice_twitch_atlas_event as c 
        where a.product_id = c.product_id 
        and c.start_time >= utc_date() 
        and c.start_time <= date_add(utc_date(), interval 30 day)
	) as count_of_upcoming_events,
    a.premium_content_creator_id,
    case 
		when fp.product_id is not null 
        then concat('https://assets.atlas.xarth.tv/P/', a.product_id, '/images/', fp.asset_location, '/', fp.asset_id, '.', fp.asset_file_type)
    else null end as front_page_asset
from
	production.microservice_twitch_atlas_product as a
left join production.microservice_twitch_atlas_product_assets as fp
	on a.product_id = fp.product_id
    and fp.asset_location = 'front-page-promotional-banner-slot'
;