create or replace view production.vw_atlas_product_details
as
select
    *,
    /* {"name": "<field>", "type": "string"}, */
    concat('{"name": "',  column_name, '", "type": "', formatted_field_type, '"},') as formatted_string
from
(	
    select 
        table_name,
        column_name,
        data_type,
        coalesce(character_maximum_length, numeric_precision) as max_length,
        case
            when data_type = 'int' then 'int'
            when data_type = 'varchar' then 'string'
            when data_type = 'tinyint' then 'boolean'
            when data_type = 'datetime' then 'timestamp'
            when data_type = 'float' then 'float'
            when data_type = 'bigint' then 'bigint'
            else 'UNKNOWN'
        end as formatted_field_type
    from information_schema.columns
    where table_schema = 'development'
) as dat
;