/* Development */
create or replace view development.vw_atlas_season_details
as
select
    a.season_id,
    a.season_name,
    b.product_id,
    b.product_name,
    a.start_time, 
    a.end_time,
    a.pledged_hours_broadcast,
    a.prize_pool,
    previous_season_id,
    previous_season_name,
    case
        when a.is_active and b.is_active then true 
        else false 
    end as is_active
from development.microservice_twitch_atlas_season as a
inner join development.microservice_twitch_atlas_product as b
    on a.product_id = b.product_id
;

/* Staging */
create or replace view staging.vw_atlas_season_details
as
select
    a.season_id,
    a.season_name,
    b.product_id,
    b.product_name,
    a.start_time, 
    a.end_time,
    a.pledged_hours_broadcast,
    a.prize_pool,
    previous_season_id,
    previous_season_name,
    case
        when a.is_active and b.is_active then true 
        else false 
    end as is_active
from staging.microservice_twitch_atlas_season as a
inner join staging.microservice_twitch_atlas_product as b
    on a.product_id = b.product_id
;

/* Production */
create or replace view production.vw_atlas_season_details
as
select
    a.season_id,
    a.season_name,
    b.product_id,
    b.product_name,
    a.start_time, 
    a.end_time,
    a.pledged_hours_broadcast,
    a.prize_pool,
    previous_season_id,
    previous_season_name,
    case
        when a.is_active and b.is_active then true 
        else false 
    end as is_active
from production.microservice_twitch_atlas_season as a
inner join production.microservice_twitch_atlas_product as b
    on a.product_id = b.product_id
;
