update
    {Constants.DatabaseSchema}microservice_twitch_user_scorecard t
inner join {Constants.DatabaseSchema}microservice_staging_twitch_user_auto_scorecard as s
    on t.TwitchUserID = s.TwitchUserID
set
    t.Login = s.Login,
    t.DataSourced = s.DataSourced,
    t.HasProfileImage = s.HasProfileImage,
    t.HasUsedEvents = s.HasUsedEvents,
    t.MeetsOrExceedsChannelPanelCount = s.MeetsOrExceedsChannelPanelCount,
    t.HasUsedRules = s.HasUsedRules,
    t.MeetsOrExceedsCollectionsCount = s.MeetsOrExceedsCollectionsCount,
    t.AutomodEnabled = s.AutomodEnabled,
    t.MeetsOrExceedsVodCount = s.MeetsOrExceedsVodCount,
    t.MeetsOrExceedsUploadCount = s.MeetsOrExceedsUploadCount,
    t.MeetsOrExceedsEmoteCount = s.MeetsOrExceedsEmoteCount,
    t.MeetsOrExceedsCheermoteCount = s.MeetsOrExceedsCheermoteCount,
    t.MeetsOrExceedsClipCount = s.MeetsOrExceedsClipCount,
    t.MeetsOrExceedsTenureBadgeCount = s.MeetsOrExceedsTenureBadgeCount,
    t.MeetsOrExceedsExtensionInstallCount = s.MeetsOrExceedsExtensionInstallCount,
    t.MeetsOrExceedsModeratorCount = s.MeetsOrExceedsModeratorCount
where
    t.TwitchUserID = s.TwitchUserID
;

insert into {Constants.DatabaseSchema}microservice_twitch_user_scorecard
(
    TwitchUserID, Login, DataSourced, HasProfileImage, HasUsedEvents, MeetsOrExceedsChannelPanelCount, HasUsedRules,
    MeetsOrExceedsCollectionsCount, AutomodEnabled, MeetsOrExceedsVodCount, MeetsOrExceedsHighlightCount, MeetsOrExceedsUploadCount,
    MeetsOrExceedsEmoteCount, MeetsOrExceedsCheermoteCount, MeetsOrExceedsClipCount, MeetsOrExceedsTenureBadgeCount,
    MeetsOrExceedsExtensionInstallCount
)
select
    TwitchUserID, Login, DataSourced, HasProfileImage, HasUsedEvents, MeetsOrExceedsChannelPanelCount, HasUsedRules,
    MeetsOrExceedsCollectionsCount, AutomodEnabled, MeetsOrExceedsVodCount, MeetsOrExceedsHighlightCount, MeetsOrExceedsUploadCount,
    MeetsOrExceedsEmoteCount, MeetsOrExceedsCheermoteCount, MeetsOrExceedsClipCount, MeetsOrExceedsTenureBadgeCount,
    MeetsOrExceedsExtensionInstallCount
from {Constants.DatabaseSchema}microservice_staging_twitch_user_auto_scorecard as a
where not exists
(
    select 1
    from {Constants.DatabaseSchema}microservice_twitch_user_scorecard as b
    where a.TwitchUserID = b.TwitchUserID
)
;