update development.microservice_twitch_user_details as t
inner join development.microservice_twitch_user_listing_past_360_days as s
    on t.ChannelID = s.ChannelID
set
    t.MaxDate = s.MaxDate,
    t.Login = s.Login,
    t.CCUTier = s.CCUTier,
    t.LastBroadcastDate = s.LastBroadcastDate,
    t.UserType = s.UserType,
    t.SubsTotal = s.SubsTotal,
    t.FollowerCountTotal = s.FollowerCountTotal,
    t.ProfileImage = s.ProfileImage,
    t.AccountManagerFullName = s.AccountManager,
    t.MinutesWatchedData = s.MinutesWatchedData,
    t.AverageCcuData = s.AverageCcuData
;

insert into development.microservice_twitch_user_details
(
    MaxDate, ChannelID, Login, CCUTier, LastBroadcastDate, UserType, SubsTotal,
    FollowerCountTotal, ProfileImage, AccountManagerUserName, AccountManagerFullName,
    MinutesWatchedData, AverageCcuData
)
select
    MaxDate,
    ChannelID,
    Login,
    CCUTier,
    LastBroadcastDate,
    UserType,
    SubsTotal,
    FollowerCountTotal,
    ProfileImage,
    '',
    AccountManager,
    MinutesWatchedData,
    AverageCcuData
from development.microservice_twitch_user_listing_past_360_days as a
where not exists
(
    select 1
    from development.microservice_twitch_user_details as b
    where a.ChannelID = b.ChannelID
);