/* Tahoe */
with countrydata as
(
     select
        a.channel_id,
        a.country_code,
        coalesce(b.country_name, 'Unknown') as country_name,
        a.rank
    from cubes.amp_channel_country_ranking_top5 as a
    left join warehouse.dim_country as b
        on a.country_code = b.country_code_two_letter
)
select
    channel_id,
    country_code,
    country_name,
    rank
from
    countrydata
;


/* Mysql */
replace into development.microservice_twitch_user_top_countries
(
    channel_id,
    country_code,
    country_name,
    rank
)
select
    base.channel_id,
    coalesce(content.country_code, 'None') as country_code,
    coalesce(content.country_name, 'None') as country_name,
    base.rank
from
(
    select
        channel_id,
        rank
    from
    (
        select 1 as rank
        union all select 2 as rank
        union all select 3 as rank
        union all select 4 as rank
        union all select 5 as rank
    ) as ranks
    cross join
    (
        select channel_id
        from development.microservice_staging_twitch_user_top_countries
        group by channel_id
    ) as channels
) as base
left join development.microservice_staging_twitch_user_top_countries as content
    on base.channel_id = content.channel_id
    and base.rank = content.rank
;