/* Development */
create table development.maintenance_table_tracking
(
    `Type` varchar(100) not null,
    `Schema` varchar(100) not null,
    `Name` varchar(100) not null,
    `Sql` varchar(8000) null,
    primary key (`Type`, `Schema`, `Name`)
);

create table development.maintenance_staging_table_tracking
(
    `Type` varchar(100) not null,
    `Schema` varchar(100) not null,
    `Name` varchar(100) not null,
    `Sql` varchar(8000) null,
    primary key (`Type`, `Schema`, `Name`)
);

create table development.maintenance_table_tracking_definition
(
    `Type` varchar(100) not null,
    `Schema` varchar(100) not null,
    `Name` varchar(100) not null,
    `Definition` varchar(8000) null,
    primary key (`Type`, `Schema`, `Name`)
);

create table development.maintenance_staging_table_tracking_definition
(
    `Type` varchar(100) not null,
    `Schema` varchar(100) not null,
    `Name` varchar(100) not null,
    `Definition` varchar(8000) null,
    primary key (`Type`, `Schema`, `Name`)
);

create table development.maintenance_table_column_tracking
(
    `Type` varchar(100) not null,
    `Schema` varchar(100) not null,
    `Name` varchar(100) not null,
    `ColumnName` varchar(255) not null,
    `ColumnType` varchar(255) not null,
    `OrdinalPosition` int not null,
    `IsNullable` boolean not null,
    `IsActive` boolean not null,
    `Definition` varchar(8000) null,
    primary key (`Type`, `Schema`, `Name`, `ColumnName`)
);

create table development.maintenance_staging_table_column_tracking
(
    `Type` varchar(100) not null,
    `Schema` varchar(100) not null,
    `Name` varchar(100) not null,
    `ColumnName` varchar(255) not null,
    `ColumnType` varchar(255) not null,
    `OrdinalPosition` int not null,
    `IsNullable` boolean not null,
    `IsActive` boolean not null,
    `Definition` varchar(8000) null,
    primary key (`Type`, `Schema`, `Name`, `ColumnName`)
);

create table development.maintenance_table_audit
(
    `ID` bigint not null auto_increment,
    `Type` varchar(100) not null,
    `Schema` varchar(100) not null,
    `Name` varchar(100) not null,
    `AuditType` varchar(100) not null,
    `AuditDate` datetime not null,
    `AuditInfo` varchar(7500) not null,
    primary key (ID)
);

create index ix_maintenance_table_audit on development.maintenance_table_audit (`Type`,`Schema`,`Name`);

create table development.maintenance_staging_table_audit
(
    `Type` varchar(100) not null,
    `Schema` varchar(100) not null,
    `Name` varchar(100) not null,
    `AuditType` varchar(100) not null,
    `AuditDate` datetime not null,
    `AuditInfo` varchar(7500) not null
);

create index ix_maintenance_staging_table_audit on development.maintenance_staging_table_audit (`Type`,`Schema`,`Name`);

/* Staging */
create table staging.maintenance_table_tracking
(
    `Type` varchar(100) not null,
    `Schema` varchar(100) not null,
    `Name` varchar(100) not null,
    `Sql` varchar(8000) null,
    primary key (`Type`, `Schema`, `Name`)
);

create table staging.maintenance_staging_table_tracking
(
    `Type` varchar(100) not null,
    `Schema` varchar(100) not null,
    `Name` varchar(100) not null,
    `Sql` varchar(8000) null,
    primary key (`Type`, `Schema`, `Name`)
);

create table staging.maintenance_table_tracking_definition
(
    `Type` varchar(100) not null,
    `Schema` varchar(100) not null,
    `Name` varchar(100) not null,
    `Definition` varchar(8000) null,
    primary key (`Type`, `Schema`, `Name`)
);

create table staging.maintenance_staging_table_tracking_definition
(
    `Type` varchar(100) not null,
    `Schema` varchar(100) not null,
    `Name` varchar(100) not null,
    `Definition` varchar(8000) null,
    primary key (`Type`, `Schema`, `Name`)
);

create table staging.maintenance_table_column_tracking
(
    `Type` varchar(100) not null,
    `Schema` varchar(100) not null,
    `Name` varchar(100) not null,
    `ColumnName` varchar(255) not null,
    `ColumnType` varchar(255) not null,
    `OrdinalPosition` int not null,
    `IsNullable` boolean not null,
    `IsActive` boolean not null,
    `Definition` varchar(8000) null,
    primary key (`Type`, `Schema`, `Name`, `ColumnName`)
);

create table staging.maintenance_staging_table_column_tracking
(
    `Type` varchar(100) not null,
    `Schema` varchar(100) not null,
    `Name` varchar(100) not null,
    `ColumnName` varchar(255) not null,
    `ColumnType` varchar(255) not null,
    `OrdinalPosition` int not null,
    `IsNullable` boolean not null,
    `IsActive` boolean not null,
    `Definition` varchar(8000) null,
    primary key (`Type`, `Schema`, `Name`, `ColumnName`)
);

create table staging.maintenance_table_audit
(
    `ID` bigint not null auto_increment,
    `Type` varchar(100) not null,
    `Schema` varchar(100) not null,
    `Name` varchar(100) not null,
    `AuditType` varchar(100) not null,
    `AuditDate` datetime not null,
    `AuditInfo` varchar(7500) not null,
    primary key (ID)
);

create index ix_maintenance_table_audit on staging.maintenance_table_audit (`Type`,`Schema`,`Name`);

create table staging.maintenance_staging_table_audit
(
    `Type` varchar(100) not null,
    `Schema` varchar(100) not null,
    `Name` varchar(100) not null,
    `AuditType` varchar(100) not null,
    `AuditDate` datetime not null,
    `AuditInfo` varchar(7500) not null
);

create index ix_maintenance_staging_table_audit on staging.maintenance_staging_table_audit (`Type`,`Schema`,`Name`);