/* Development */
create table development.microservice_twitch_user_game_stats
(
    ChannelID bigint not null, 
    AggregationType int not null,
    MinDate datetime not null,
    MaxDate datetime not null,
    UniqueDaysFound int not null, 
    UniqueDaysPossible int not null,
    GameName varchar(255) null,
    GameId varchar(255) null,
    GiantbombId varchar(255) null,
    MinutesBroadcastTotal bigint not null,
    MinutesWatchedTotal bigint not null,
    GameStartCount int not null,
    PeakViewership int not null,
    AverageViewership float not null,
    primary key (ChannelID, AggregationType, GameName, GameId)
);

create table development.microservice_staging_twitch_user_game_stats
(
    ChannelID bigint not null, 
    AggregationType int not null,
    MinDate datetime not null,
    MaxDate datetime not null,
    UniqueDaysFound int not null, 
    UniqueDaysPossible int not null,
    GameName varchar(255) null,
    GameId varchar(255) null,
    GiantbombId varchar(255) null,
    MinutesBroadcastTotal bigint not null,
    MinutesWatchedTotal bigint not null,
    GameStartCount int not null,
    PeakViewership int not null,
    AverageViewership float not null,
    primary key (ChannelID, AggregationType, GameName, GameId)
);

/* Staging */
create table staging.microservice_twitch_user_game_stats
(
    ChannelID bigint not null, 
    AggregationType int not null,
    MinDate datetime not null,
    MaxDate datetime not null,
    UniqueDaysFound int not null, 
    UniqueDaysPossible int not null,
    GameName varchar(255) null,
    GameId varchar(255) null,
    GiantbombId varchar(255) null,
    MinutesBroadcastTotal bigint not null,
    MinutesWatchedTotal bigint not null,
    GameStartCount int not null,
    PeakViewership int not null,
    AverageViewership float not null,
    primary key (ChannelID, AggregationType, GameName, GameId)
);

create table staging.microservice_staging_twitch_user_game_stats
(
    ChannelID bigint not null, 
    AggregationType int not null,
    MinDate datetime not null,
    MaxDate datetime not null,
    UniqueDaysFound int not null, 
    UniqueDaysPossible int not null,
    GameName varchar(255) null,
    GameId varchar(255) null,
    GiantbombId varchar(255) null,
    MinutesBroadcastTotal bigint not null,
    MinutesWatchedTotal bigint not null,
    GameStartCount int not null,
    PeakViewership int not null,
    AverageViewership float not null,
    primary key (ChannelID, AggregationType, GameName, GameId)
);

/* Production */
create table production.microservice_twitch_user_game_stats
(
    ChannelID bigint not null, 
    AggregationType int not null,
    MinDate datetime not null,
    MaxDate datetime not null,
    UniqueDaysFound int not null, 
    UniqueDaysPossible int not null,
    GameName varchar(255) null,
    GameId varchar(255) null,
    GiantbombId varchar(255) null,
    MinutesBroadcastTotal bigint not null,
    MinutesWatchedTotal bigint not null,
    GameStartCount int not null,
    PeakViewership int not null,
    AverageViewership float not null,
    primary key (ChannelID, AggregationType, GameName, GameId)
);

create table production.microservice_staging_twitch_user_game_stats
(
    ChannelID bigint not null, 
    AggregationType int not null,
    MinDate datetime not null,
    MaxDate datetime not null,
    UniqueDaysFound int not null, 
    UniqueDaysPossible int not null,
    GameName varchar(255) null,
    GameId varchar(255) null,
    GiantbombId varchar(255) null,
    MinutesBroadcastTotal bigint not null,
    MinutesWatchedTotal bigint not null,
    GameStartCount int not null,
    PeakViewership int not null,
    AverageViewership float not null,
    primary key (ChannelID, AggregationType, GameName, GameId)
);