/* BEGIN DEVELOPMENT */
create table development.microservice_twitch_user_scorecard
(
    /* Data Driven */
    TwitchUserID bigint not null,
    Login varchar(64) not null,
    DataSourced datetime not null,

    HasProfileImage boolean null,
    HasUsedEvents boolean null,
    MeetsOrExceedsChannelPanelCount boolean null,
    HasUsedRules boolean null,
    MeetsOrExceedsCollectionsCount boolean null,
    AutomodEnabled boolean null,
    MeetsOrExceedsVodCount boolean null,
    MeetsOrExceedsHighlightCount boolean null,
    MeetsOrExceedsUploadCount boolean null,
    MeetsOrExceedsEmoteCount boolean null,
    MeetsOrExceedsCheermoteCount boolean null,
    MeetsOrExceedsClipCount boolean null,
    MeetsOrExceedsTenureBadgeCount boolean null,
    MeetsOrExceedsExtensionInstallCount boolean null,

    /* Unidentified Data Source */
    HasBio boolean null,  
    HasStandardBackground boolean null,
    HasVideoPlayerBanner boolean null,
    HasChatBot boolean null,
    MeetsOrExceedsTagCount boolean null,
    MeetsOrExceedsModeratorCount boolean null,
    MeetsOrExceedsChatVanityCount boolean null,
    MeetsOrExceedsEditorCount boolean null,
    MeetsOrExceedsAutohostCount boolean null,

    /* No Automatic Data Available */
    HasAlerts boolean null,
    HasOverlays boolean null,
    HasAudioBalance boolean null,
    HasLightingBalance boolean null,
    HasDistinctFocalPoints boolean null,
    HasDiscordServer boolean null,
    HasRituals boolean null,
    HasSocialMedia boolean null,
    HasCategory boolean null,

    primary key (TwitchUserID)
);

/* Population Table: Staging: Auto */
create table development.microservice_staging_twitch_user_auto_scorecard
(
    TwitchUserID bigint not null, 
    Login varchar(64) not null, 
    DataSourced datetime not null, 
    HasProfileImage boolean null, 
    HasUsedEvents boolean null,
    MeetsOrExceedsChannelPanelCount boolean null, 
    HasUsedRules boolean null, 
    MeetsOrExceedsCollectionsCount boolean null,
    AutomodEnabled boolean null, 
    MeetsOrExceedsVodCount boolean null, 
    MeetsOrExceedsHighlightCount boolean null,
    MeetsOrExceedsUploadCount boolean null, 
    MeetsOrExceedsEmoteCount boolean null,
    MeetsOrExceedsCheermoteCount boolean null, 
    MeetsOrExceedsClipCount boolean null, 
    MeetsOrExceedsTenureBadgeCount boolean null,
    MeetsOrExceedsExtensionInstallCount boolean null, 
    MeetsOrExceedsModeratorCount boolean null,
    MeetsOrExceedsTagCount boolean null,
    primary key (TwitchUserID)
);

/* Population Table: Staging: Manual */
create table development.microservice_staging_twitch_user_manual_scorecard
(
    TwitchUserID bigint not null,
    DataSourced datetime not null,
    DataSourcedBy varchar(100) not null,
    HasAlerts boolean null,
    HasOverlays boolean null,
    HasAudioBalance boolean null,
    HasLightingBalance boolean null,
    HasDistinctFocalPoints boolean null,
    HasDiscordServer boolean null,
    HasRituals boolean null,
    HasSocialMedia boolean null,
    primary key (TwitchUserID)
);
/* END DEVELOPMENT */

/* BEGIN STAGING */
create table staging.microservice_twitch_user_scorecard
(
    /* Data Driven */
    TwitchUserID bigint not null,
    Login varchar(64) not null,
    DataSourced datetime not null,

    HasProfileImage boolean null,
    HasUsedEvents boolean null,
    MeetsOrExceedsChannelPanelCount boolean null,
    HasUsedRules boolean null,
    MeetsOrExceedsCollectionsCount boolean null,
    AutomodEnabled boolean null,
    MeetsOrExceedsVodCount boolean null,
    MeetsOrExceedsHighlightCount boolean null,
    MeetsOrExceedsUploadCount boolean null,
    MeetsOrExceedsEmoteCount boolean null,
    MeetsOrExceedsCheermoteCount boolean null,
    MeetsOrExceedsClipCount boolean null,
    MeetsOrExceedsTenureBadgeCount boolean null,
    MeetsOrExceedsExtensionInstallCount boolean null,

    /* Unidentified Data Source */
    HasBio boolean null,  
    HasStandardBackground boolean null,
    HasVideoPlayerBanner boolean null,
    HasChatBot boolean null,
    MeetsOrExceedsTagCount boolean null,
    MeetsOrExceedsModeratorCount boolean null,
    MeetsOrExceedsChatVanityCount boolean null,
    MeetsOrExceedsEditorCount boolean null,
    MeetsOrExceedsAutohostCount boolean null,

    /* No Automatic Data Available */
    HasAlerts boolean null,
    HasOverlays boolean null,
    HasAudioBalance boolean null,
    HasLightingBalance boolean null,
    HasDistinctFocalPoints boolean null,
    HasDiscordServer boolean null,
    HasRituals boolean null,
    HasSocialMedia boolean null,
    HasCategory boolean null,

    primary key (TwitchUserID)
);

/* Population Table: Staging: Auto */
create table staging.microservice_staging_twitch_user_auto_scorecard
(
    TwitchUserID bigint not null, 
    Login varchar(64) not null, 
    DataSourced datetime not null, 
    HasProfileImage boolean null, 
    HasUsedEvents boolean null,
    MeetsOrExceedsChannelPanelCount boolean null, 
    HasUsedRules boolean null, 
    MeetsOrExceedsCollectionsCount boolean null,
    AutomodEnabled boolean null, 
    MeetsOrExceedsVodCount boolean null, 
    MeetsOrExceedsHighlightCount boolean null,
    MeetsOrExceedsUploadCount boolean null, 
    MeetsOrExceedsEmoteCount boolean null,
    MeetsOrExceedsCheermoteCount boolean null, 
    MeetsOrExceedsClipCount boolean null, 
    MeetsOrExceedsTenureBadgeCount boolean null,
    MeetsOrExceedsExtensionInstallCount boolean null, 
    MeetsOrExceedsModeratorCount boolean null,
    MeetsOrExceedsTagCount boolean null,
    primary key (TwitchUserID)
);

/* Population Table: Staging: Manual */
create table staging.microservice_staging_twitch_user_manual_scorecard
(
    TwitchUserID bigint not null,
    DataSourced datetime not null,
    DataSourcedBy varchar(100) not null,
    HasAlerts boolean null,
    HasOverlays boolean null,
    HasAudioBalance boolean null,
    HasLightingBalance boolean null,
    HasDistinctFocalPoints boolean null,
    HasDiscordServer boolean null,
    HasRituals boolean null,
    HasSocialMedia boolean null,
    primary key (TwitchUserID)
);
/* END STAGING */

/* BEGIN PRODUCTION */
create table production.microservice_twitch_user_scorecard
(
    /* Data Driven */
    TwitchUserID bigint not null,
    Login varchar(64) not null,
    DataSourced datetime not null,

    HasProfileImage boolean null,
    HasUsedEvents boolean null,
    MeetsOrExceedsChannelPanelCount boolean null,
    HasUsedRules boolean null,
    MeetsOrExceedsCollectionsCount boolean null,
    AutomodEnabled boolean null,
    MeetsOrExceedsVodCount boolean null,
    MeetsOrExceedsHighlightCount boolean null,
    MeetsOrExceedsUploadCount boolean null,
    MeetsOrExceedsEmoteCount boolean null,
    MeetsOrExceedsCheermoteCount boolean null,
    MeetsOrExceedsClipCount boolean null,
    MeetsOrExceedsTenureBadgeCount boolean null,
    MeetsOrExceedsExtensionInstallCount boolean null,

    /* Unidentified Data Source */
    HasBio boolean null,  
    HasStandardBackground boolean null,
    HasVideoPlayerBanner boolean null,
    HasChatBot boolean null,
    MeetsOrExceedsTagCount boolean null,
    MeetsOrExceedsModeratorCount boolean null,
    MeetsOrExceedsChatVanityCount boolean null,
    MeetsOrExceedsEditorCount boolean null,
    MeetsOrExceedsAutohostCount boolean null,

    /* No Automatic Data Available */
    HasAlerts boolean null,
    HasOverlays boolean null,
    HasAudioBalance boolean null,
    HasLightingBalance boolean null,
    HasDistinctFocalPoints boolean null,
    HasDiscordServer boolean null,
    HasRituals boolean null,
    HasSocialMedia boolean null,
    HasCategory boolean null,

    primary key (TwitchUserID)
);

/* Population Table: Staging: Auto */
create table production.microservice_staging_twitch_user_auto_scorecard
(
    TwitchUserID bigint not null, 
    Login varchar(64) not null, 
    DataSourced datetime not null, 
    HasProfileImage boolean null, 
    HasUsedEvents boolean null,
    MeetsOrExceedsChannelPanelCount boolean null, 
    HasUsedRules boolean null, 
    MeetsOrExceedsCollectionsCount boolean null,
    AutomodEnabled boolean null, 
    MeetsOrExceedsVodCount boolean null, 
    MeetsOrExceedsHighlightCount boolean null,
    MeetsOrExceedsUploadCount boolean null, 
    MeetsOrExceedsEmoteCount boolean null,
    MeetsOrExceedsCheermoteCount boolean null, 
    MeetsOrExceedsClipCount boolean null, 
    MeetsOrExceedsTenureBadgeCount boolean null,
    MeetsOrExceedsExtensionInstallCount boolean null, 
    MeetsOrExceedsModeratorCount boolean null,
    MeetsOrExceedsTagCount boolean null,
    primary key (TwitchUserID)
);

/* Population Table: Staging: Manual */
create table production.microservice_staging_twitch_user_manual_scorecard
(
    TwitchUserID bigint not null,
    DataSourced datetime not null,
    DataSourcedBy varchar(100) not null,
    HasAlerts boolean null,
    HasOverlays boolean null,
    HasAudioBalance boolean null,
    HasLightingBalance boolean null,
    HasDistinctFocalPoints boolean null,
    HasDiscordServer boolean null,
    HasRituals boolean null,
    HasSocialMedia boolean null,
    primary key (TwitchUserID)
);
/* END PRODUCTION */