#**********************************************************************************************
Wrapping Query:
set profiling=1;
execute stmt;
show profile;

flush status;
execute stmt;
show session status like 'Select%';
show status like 'last_query_cost';

#***********************************************************************************************
TwitchUserListing Overview
Query:
drop table if exists user_listing_population;
create temporary table user_listing_population(channelid bigint,maxccu bigint, channelconcurrentsminuteswatchedtotal bigint, channelconcurrentsminutesbroadcasttotal bigint, uniquedaysbroadcast int, topgamebroadcast varchar(50), ccutier varchar(50), averageccu float8);
insert into user_listing_population
select channelid,maxccu,channelconcurrentsminuteswatchedtotal,channelconcurrentsminutesbroadcasttotal,uniquedaysbroadcast,topgamebroadcast,ccutier,averageccu
from development.microservice_twitch_user_listing
where AggregationType = 30
order by channelconcurrentsminuteswatchedtotal DESC
limit 5000;
;

prepare stmt from 
'
select channelid,login,channelconcurrentsminuteswatchedtotal,channelconcurrentsminutesbroadcasttotal,maxccu,averageccu,followercounttotal,uniquedaysbroadcast,topgamebroadcast,minuteswatcheddata,averageccudata,profileimage,subssoldtotal,substotal
from development.microservice_twitch_user_listing
where AggregationType = 30
order by channelconcurrentsminuteswatchedtotal DESC
limit 12 offset 0 ;
';

Summary:
# Duration, CPU_User, CPU_System
0.121039, 0.148000, 0.000000

Detailed:
# Status,                           Duration, CPU_user, CPU_system
starting,                           0.000032, 0.000000, 0.000000
checking query cache for query,     0.000018, 0.000000, 0.000000
checking permissions,               0.000015, 0.000000, 0.000000
Opening tables,                     0.000020, 0.000000, 0.000000
init,                               0.000026, 0.000000, 0.000000
System lock,                        0.000037, 0.000000, 0.000000
optimizing,                         0.000020, 0.000000, 0.000000
statistics,                         0.000073, 0.000000, 0.000000
preparing,                          0.000024, 0.000000, 0.000000
Sorting result,                     0.000014, 0.000000, 0.000000
executing,                          0.000014, 0.000000, 0.000000
Sending data,                       0.000021, 0.000000, 0.000000
Creating sort index,                0.120583, 0.148000, 0.000000
end,                                0.000018, 0.000000, 0.000000
query end,                          0.000018, 0.000000, 0.000000
closing tables,                     0.000021, 0.000000, 0.000000
query end,                          0.000013, 0.000000, 0.000000
closing tables,                     0.000014, 0.000000, 0.000000
freeing items,                      0.000030, 0.000000, 0.000000
storing result in query cache,      0.000014, 0.000000, 0.000000
cleaning up,                        0.000014, 0.000000, 0.000000

#**********************************************************************************************
TwitchUserListing (base)
Query:
prepare stmt from 
'
select channelid,login,ccutier,channelconcurrentsminuteswatchedtotal,channelconcurrentsminutesbroadcasttotal,maxccu,averageccu,followercounttotal,uniquedaysbroadcast,topgamebroadcast,minuteswatcheddata,averageccudata,profileimage,subssoldtotal
from development.microservice_twitch_user_listing
where AggregationType = 30
order by channelconcurrentsminuteswatchedtotal DESC
limit 12
offset 0;
';

Summary:
# Duration, CPU_User, CPU_System
0.119326, 0.144000, 0.000000

Detailed:
# Status,                           Duration, CPU_user, CPU_system
starting,                           0.000025, 0.000000, 0.000000
checking query cache for query,     0.000016, 0.000000, 0.000000
checking permissions,               0.000013, 0.000000, 0.000000
Opening tables,                     0.000019, 0.000000, 0.000000
init,                               0.000025, 0.000000, 0.000000
System lock,                        0.000029, 0.000000, 0.000000
optimizing,                         0.000018, 0.000000, 0.000000
statistics,                         0.000072, 0.000000, 0.000000
preparing,                          0.000023, 0.000000, 0.000000
Sorting result,                     0.000012, 0.000000, 0.000000
executing,                          0.000012, 0.000000, 0.000000
Sending data,                       0.000019, 0.000000, 0.000000
Creating sort index,                0.118911, 0.144000, 0.000000
end,                                0.000017, 0.000000, 0.000000
query end,                          0.000015, 0.000000, 0.000000
closing tables,                     0.000020, 0.000000, 0.000000
query end,                          0.000012, 0.000000, 0.000000
closing tables,                     0.000015, 0.000000, 0.000000
freeing items,                      0.000029, 0.000000, 0.000000
storing result in query cache,      0.000012, 0.000000, 0.000000
cleaning up,                        0.000012, 0.000000, 0.000000


#**********************************************************************************************
TwitchUserListing (filter - Channel Concurrent Minutes Watched)
Query
prepare stmt from 
'
select channelid,login,ccutier,channelconcurrentsminuteswatchedtotal,channelconcurrentsminutesbroadcasttotal,maxccu,averageccu,followercounttotal,uniquedaysbroadcast,topgamebroadcast,minuteswatcheddata,averageccudata,profileimage,subssoldtotal
from development.microservice_twitch_user_listing
where AggregationType = 30
and (channelconcurrentsminuteswatchedtotal <= 500)
and (channelconcurrentsminuteswatchedtotal >= 100)
order by channelconcurrentsminuteswatchedtotal ASC
limit 12
offset 0;
';

Summary:
# Duration, CPU_User, CPU_System
0.120580, 0.148000, 0.000000

Detailed:
# Status,                           Duration, CPU_user, CPU_system
starting,                           0.000024, 0.000000, 0.000000
checking query cache for query,     0.000017, 0.000000, 0.000000
checking permissions,               0.000014, 0.000000, 0.000000
Opening tables,                     0.000020, 0.000000, 0.000000
init,                               0.000030, 0.000000, 0.000000
System lock,                        0.000030, 0.000000, 0.000000
optimizing,                         0.000021, 0.000000, 0.000000
statistics,                         0.000074, 0.000000, 0.000000
preparing,                          0.000023, 0.000000, 0.000000
Sorting result,                     0.000013, 0.000000, 0.000000
executing,                          0.000013, 0.000000, 0.000000
Sending data,                       0.000019, 0.000000, 0.000000
Creating sort index,                0.120153, 0.148000, 0.000000
end,                                0.000017, 0.000000, 0.000000
query end,                          0.000016, 0.000000, 0.000000
closing tables,                     0.000023, 0.000000, 0.000000
query end,                          0.000012, 0.000000, 0.000000
closing tables,                     0.000012, 0.000000, 0.000000
freeing items,                      0.000023, 0.000000, 0.000000
storing result in query cache,      0.000013, 0.000000, 0.000000
cleaning up,                        0.000013, 0.000000, 0.000000

#**********************************************************************************************
TwitchUserListing (filter - Login Contains)
Query:

drop table if exists user_listing_population;
create temporary table user_listing_population(channelid bigint,maxccu bigint, channelconcurrentsminuteswatchedtotal bigint, channelconcurrentsminutesbroadcasttotal bigint, uniquedaysbroadcast int, topgamebroadcast varchar(50), ccutier varchar(50), averageccu float8);

prepare stmt from 
'
insert into user_listing_population
select channelid,maxccu,channelconcurrentsminuteswatchedtotal,channelconcurrentsminutesbroadcasttotal,uniquedaysbroadcast,topgamebroadcast,ccutier,averageccu
from development.microservice_twitch_user_listing
where AggregationType = 30
and (login like ''%'' || ''ninja''|| ''%'')
order by channelconcurrentsminuteswatchedtotal DESC
limit 5000;
';

Summary:
# Variable_name, Value
Last_query_cost, 154992.399000

# Duration, CPU_User, CPU_System
0.000105, 0.000000, 0.000000

# Status,           Duration, CPU_user, CPU_system
starting,           0.000039, 0.000000, 0.000000
query end,          0.000015, 0.000000, 0.000000
closing tables,     0.000015, 0.000000, 0.000000
freeing items,      0.000022, 0.000000, 0.000000
cleaning up,        0.000014, 0.000000, 0.000000

#**********************************************************************************************
TwitchUserListing (filter - Account Manager)
Unavailable

#**********************************************************************************************
TwitchUserListing (filter - Top Game)
Query
prepare stmt from 
'
select channelid,login,ccutier,channelconcurrentsminuteswatchedtotal,channelconcurrentsminutesbroadcasttotal,maxccu,averageccu,followercounttotal,uniquedaysbroadcast,topgamebroadcast,minuteswatcheddata,averageccudata,profileimage,subssoldtotal
from development.microservice_twitch_user_listing
where AggregationType = 30
and (topgamebroadcast = ''Just Chatting'')
order by channelconcurrentsminuteswatchedtotal DESC
limit 12 offset 0;
';

Summary:
# Duration, CPU_User, CPU_System
0.131572, 0.156000, 0.000000

Detailed:
# Status,                           Duration, CPU_user, CPU_system
starting,                           0.000026, 0.000000, 0.000000
checking query cache for query,     0.000017, 0.000000, 0.000000
checking permissions,               0.000014, 0.000000, 0.000000
Opening tables,                     0.000020, 0.000000, 0.000000
init,                               0.000027, 0.000000, 0.000000
System lock,                        0.000038, 0.000000, 0.000000
optimizing,                         0.000020, 0.000000, 0.000000
statistics,                         0.000078, 0.000000, 0.000000
preparing,                          0.000026, 0.000000, 0.000000
Sorting result,                     0.000013, 0.000000, 0.000000
executing,                          0.000013, 0.000000, 0.000000
Sending data,                       0.000020, 0.000000, 0.000000
Creating sort index,                0.131123, 0.156000, 0.000000
end,                                0.000018, 0.000000, 0.000000
query end,                          0.000016, 0.000000, 0.000000
closing tables,                     0.000022, 0.000000, 0.000000
query end,                          0.000013, 0.000000, 0.000000
closing tables,                     0.000013, 0.000000, 0.000000
freeing items,                      0.000028, 0.000000, 0.000000
storing result in query cache,      0.000013, 0.000000, 0.000000
cleaning up,                        0.000014, 0.000000, 0.000000

#**********************************************************************************************
TwitchUserListing (filter - Days Broadcast)
Query
prepare stmt from 
'
select channelid,login,ccutier,channelconcurrentsminuteswatchedtotal,channelconcurrentsminutesbroadcasttotal,maxccu,averageccu,followercounttotal,uniquedaysbroadcast,topgamebroadcast,minuteswatcheddata,averageccudata,profileimage,subssoldtotal
from development.microservice_twitch_user_listing
where AggregationType = 30
and (uniquedaysbroadcast >= 5 and uniquedaysbroadcast <= 10)
order by channelconcurrentsminuteswatchedtotal ASC
limit 12
offset 0
;
';

Summary:
# Duration, CPU_User, CPU_System
0.127365, 0.156000, 0.000000

Detailed:
# Status,                           Duration, CPU_user, CPU_system
starting,                           0.000025, 0.000000, 0.000000
checking query cache for query,     0.000017, 0.000000, 0.000000
checking permissions, 0.000015,     0.000000, 0.000000
Opening tables,                     0.000019, 0.000000, 0.000000
init,                               0.000026, 0.000000, 0.000000
System lock,                        0.000030, 0.000000, 0.000000
optimizing,                         0.000020, 0.000000, 0.000000
statistics,                         0.000084, 0.000000, 0.000000
preparing,                          0.000025, 0.000000, 0.000000
Sorting result,                     0.000014, 0.000000, 0.000000
executing,                          0.000013, 0.000000, 0.000000
Sending data,                       0.000020, 0.000000, 0.000000
Creating sort index,                0.126902, 0.156000, 0.000000
end,                                0.000027, 0.000000, 0.000000
query end,                          0.000018, 0.000000, 0.000000
closing tables,                     0.000027, 0.000000, 0.000000
query end,                          0.000013, 0.000000, 0.000000
closing tables,                     0.000013, 0.000000, 0.000000
freeing items,                      0.000030, 0.000000, 0.000000
storing result in query cache,      0.000014, 0.000000, 0.000000
cleaning up,                        0.000013, 0.000000, 0.000000

#**********************************************************************************************
TwitchUserListing (filter - Tier)
Query
prepare stmt from 
'
select channelid,login,ccutier,channelconcurrentsminuteswatchedtotal,channelconcurrentsminutesbroadcasttotal,maxccu,averageccu,followercounttotal,uniquedaysbroadcast,topgamebroadcast,minuteswatcheddata,averageccudata,profileimage,subssoldtotal
from development.microservice_twitch_user_listing
where AggregationType = 30
and ccutier in (''T3: 201-2000'',''T4: 2001+ CCU'')
order by channelconcurrentsminuteswatchedtotal ASC
limit 12
offset 0
;
';

Summary:
# Duration, CPU_User, CPU_System
0.000245, 0.000000, 0.000000

Detailed:
# Status,                           Duration, CPU_user, CPU_system
starting,                           0.000022, 0.000000, 0.000000
checking query cache for query,     0.000017, 0.000000, 0.000000
checking privileges on cached ,     0.000014, 0.000000, 0.000000
checking permissions,               0.000023, 0.000000, 0.000000
sending cached result to clien,     0.000114, 0.000000, 0.000000
query end,                          0.000014, 0.000000, 0.000000
closing tables,                     0.000014, 0.000000, 0.000000
freeing items,                      0.000014, 0.000000, 0.000000
cleaning up,                        0.000013, 0.000000, 0.000000

***********************************************************************************************
TwitchUserListing (filter - Tier + CCU)
Query
prepare stmt from 
'
select channelid,login,ccutier,channelconcurrentsminuteswatchedtotal,channelconcurrentsminutesbroadcasttotal,maxccu,averageccu,followercounttotal,uniquedaysbroadcast,topgamebroadcast,minuteswatcheddata,averageccudata,profileimage,subssoldtotal
from development.microservice_twitch_user_listing
where AggregationType = 30
and ccutier in (''T3: 201-2000 CCU'',''T4: 2001+ CCU'')
and (maxccu <= 500)
and (maxccu >= 100)
order by channelconcurrentsminuteswatchedtotal ASC
limit 12
offset 0;
';

Summary:
# Duration, CPU_User, CPU_System
0.128235, 0.156000, 0.000000

Detailed:
# Status,                           Duration, CPU_user, CPU_system
starting,                           0.000027, 0.000000, 0.000000
checking query cache for query,     0.000017, 0.000000, 0.000000
checking permissions,               0.000015, 0.000000, 0.000000
Opening tables,                     0.000019, 0.000000, 0.000000
init,                               0.000030, 0.000000, 0.000000
System lock,                        0.000033, 0.000000, 0.000000
optimizing,                         0.000021, 0.000000, 0.000000
statistics,                         0.000089, 0.000000, 0.000000
preparing,                          0.000026, 0.000000, 0.000000
Sorting result,                     0.000014, 0.000000, 0.000000
executing,                          0.000013, 0.000000, 0.000000
Sending data,                       0.000019, 0.000000, 0.000000
Creating sort index,                0.127756, 0.156000, 0.000000
end,                                0.000020, 0.000000, 0.000000
query end,                          0.000016, 0.000000, 0.000000
closing tables,                     0.000022, 0.000000, 0.000000
query end,                          0.000013, 0.000000, 0.000000
closing tables,                     0.000016, 0.000000, 0.000000
freeing items,                      0.000043, 0.000000, 0.000000
storing result in query cache,      0.000013, 0.000000, 0.000000
cleaning up,                        0.000013, 0.000000, 0.000000

***********************************************************************************************
TwitchUserListing (filter - Creator Total Revenue (range) + Prime Revenue (LT) + Bits Revenue (GT))
Query
prepare stmt from 
'
select channelid,login,channelconcurrentsminuteswatchedtotal,channelconcurrentsminutesbroadcasttotal,maxccu,averageccu,followercounttotal,uniquedaysbroadcast,topgamebroadcast,minuteswatcheddata,averageccudata,profileimage,subssoldtotal
from development.microservice_twitch_user_listing
where AggregationType = 30
and (creatorrevenuetotal >= 100 and creatorrevenuetotal <= 1000)
and (creatorprimesubrevenuetotal <= 200)
and (creatorbitsrevenuetotal >= 50)
order by channelconcurrentsminuteswatchedtotal DESC
limit 12  offset 0;
';

Summary:
# Duration, CPU_User, CPU_System
0.000270, 0.000000, 0.000000

Detailed:
# Status,                           Duration, CPU_user, CPU_system
starting,                           0.000033, 0.000000, 0.000000
checking query cache for query,     0.000017, 0.000000, 0.000000
checking privileges on cached ,     0.000014, 0.000000, 0.000000
checking permissions,               0.000023, 0.000000, 0.000000
sending cached result to clien,     0.000131, 0.000000, 0.000000
query end,                          0.000013, 0.000000, 0.000000
closing tables,                     0.000013, 0.000000, 0.000000
freeing items,                      0.000013, 0.000000, 0.000000
cleaning up,                        0.000013, 0.000000, 0.000000
