/* BEGIN TWITCH USER CALENDAR QUERY */
with apdcs as
(
    select channel_id as channel_id
    from cubes.affiliates_partners_daily_channel_summary
    where
        day >= cast('2018-07-24' as datetime)
        and coalesce(channel_id, 0) > 0
    group by channel_id
    having
    sum(
        coalesce(creator_ad_revenue, 0.0)
        + coalesce(creator_sub_revenue_total, 0.0)
        + coalesce(creator_sub_revenue_prime, 0.0)
        + coalesce(creator_bits_revenue_total, 0.0)
        + coalesce(creator_fuel_revenue, 0.0)
        + coalesce(creator_bounty_board_revenue, 0.0)
    ) >= 50
),
days as
(
    select day
    from cubes.hours_watched_daily_by_device
    where day >= cast('2019-07-01' as date)
    and day < cast('2019-08-01' as date)
    group by day
),
infractions as
(
    select
        date_trunc('day', date) as day,
        target_user_id as channel_id,
        case when account_ban_duration = -1 then 1 else 0 end as is_perm_ban,
        case when banned_until_utc is not null then 1 else 0 end as is_temp_ban
    from tahoe.leviathan_suspension as a
    where
        date >= '2019-07-01'
        and date < '2019-08-01'
),
dmca_takedown as
(
    select
        date_trunc('day', date) as day,
        content_poster_id as channel_id,
        count(*) as takedown_count
    from tahoe.dmca_takedown
    where
        date >= '2019-07-01'
        and date < '2019-08-01'
    group by
        date_trunc('day', date),
        channel_id
),
warnings as
(
    select
        date_trunc('day', date) as day,
        target_user_id as channel_id,
        count(*) as warning_count
    from tahoe.aegis_warning
    group by
        date_trunc('day', date),
        channel_id
),
minutes_watched as
(
    select
        channel_id,
        day,
        sum(mw) as minutes_watched
    from cubes.hours_watched_daily_by_device
    where day >= cast('2019-07-01' as date)
    and day < '2019-08-01'
    group by
        day,
        channel_id
),
minutes_broadcast as
(
    select
        channel_id,
        day,
        sum(minutes_broadcast_total) as minutes_broadcast_total,
        count(*) as count_times_cast
    from cubes.affiliates_partners_daily_channel_summary as a
    where
        day >= cast('2019-07-01' as date)
        and day < cast('2019-08-01' as date)
        and coalesce(channel_id, 0) > 0
    group by
        day,
        channel_id
),
bounty as
(
    select
        user_id as channel_id,
        date_trunc('day', date) as day,
        sum(case when bounty_status = 'LIVE' then 1 else 0 end) as bounty_started,
        sum(case when bounty_status = 'COMPLETED' then 1 else 0 end) as bounty_completed,
        sum(case when bounty_status = 'CANCELLED' then 1 else 0 end) as bounty_cancelled
    from tahoe.bounty_details_update
    where
        date >= '2019-07-01'
        and date < '2019-08-01'
    group by
        user_id,
        date_trunc('day', date)
)
select
    apdcs_days.channel_id,
    apdcs_days.day,
    case when sum(coalesce(dmca_takedown.takedown_count, 0)) > 0 then True else False end as has_dmca_takedown,
    case when sum(coalesce(warnings.warning_count, 0)) > 0 then True else False end as has_warning,
    case when max(coalesce(infractions.channel_id, 0)) > 0 then True else False end as has_infraction,
    case when sum(coalesce(infractions.is_perm_ban, 0)) > 0 then True else False end as is_perm_ban,
    case when sum(coalesce(infractions.is_perm_ban, 0)) = 0 and sum(coalesce(infractions.is_temp_ban, 0)) > 0 Then True else False end as is_temp_ban,
    sum(coalesce(minutes_watched.minutes_watched, 0)) as minutes_watched,
    sum(coalesce(minutes_broadcast_total, 0)) as minutes_broadcast,
    sum(coalesce(count_times_cast, 0)) as times_cast,
    case when sum(coalesce(bounty_started, 0)) > 0 then True else False end as bounty_started,
    case when sum(coalesce(bounty_completed, 0)) > 0 then True else False end as bounty_completed,
    case when sum(coalesce(bounty_cancelled, 0)) then True else False end as bounty_cancelled
from
(
    select *
    from apdcs
    cross join days
) as apdcs_days
left join infractions
    on apdcs_days.channel_id = infractions.channel_id
    and apdcs_days.day = infractions.day
left join minutes_watched
    on apdcs_days.channel_id = minutes_watched.channel_id
    and apdcs_days.day = minutes_watched.day
left join minutes_broadcast
    on apdcs_days.channel_id = minutes_broadcast.channel_id
    and apdcs_days.day = minutes_broadcast.day
left join dmca_takedown
    on apdcs_days.channel_id = dmca_takedown.channel_id
    and apdcs_days.day = dmca_takedown.day
left join warnings
    on apdcs_days.channel_id = warnings.channel_id
    and apdcs_days.day = warnings.day
left join bounty
    on apdcs_days.channel_id = bounty.channel_id
    and apdcs_days.day = bounty.day
group by
    apdcs_days.channel_id,
    apdcs_days.day
;
/* END TWITCH USER CALENDAR QUERY */