with dollar_threshold_true as
(
  select channel_id, 'DollarThresholdTrue' as check_type
  from cubes.amp_application_population
  where meets_dollar_threshold_lifetime = true
  limit 1
),
dollar_threshold_false as
(
  select channel_id, 'DollarThresholdFalse' as check_type
  from cubes.amp_application_population
  where meets_dollar_threshold_lifetime = false
  limit 1
),
ispartner as
(
  select channel_id, 'IsPartner' as check_type
  from cubes.amp_application_population
  where is_partner = true
  limit 1
),
isnotpartner as
(
  select channel_id, 'IsNotPartner' as check_type
  from cubes.amp_application_population
  where is_partner = false
  limit 1
),
ispremium as
(
  select channel_id, 'IsPremium' as check_type
  from cubes.amp_application_population
  where is_premium = true
  limit 1
),
isnotpremium as
(
  select channel_id, 'IsNotPremium' as check_type
  from cubes.amp_application_population
  where is_premium = false
  limit 1
),
custom as
(
  select channel_id, 'Custom' as check_type
  from cubes.amp_application_custom_population
  limit 1
)
select
  channel_id, check_type
from
(
  select channel_id, check_type from dollar_threshold_true
  union all
  select channel_id, check_type from dollar_threshold_false
  union all
  select channel_id, check_type from ispartner
  union all
  select channel_id, check_type from isnotpartner
  union all
  select channel_id, check_type from ispremium
  union all
  select channel_id, check_type from isnotpremium
  union all
  select channel_id, check_type from custom
) as a
;