/* BEGIN USER SCORECARD QUERY */
with apdcs as
(
    select
        day,
        channel_id,
        channel
    from cubes.affiliates_partners_daily_channel_summary
    where day = (select max(day) from cubes.affiliates_partners_daily_channel_summary)
    and right(channel_id, 1) = @channelDigit
),
users as
(
    select
        id as user_id,
        case when coalesce(profile_image, 'empty_profile_image') <> 'empty_profile_image'
            then True
            else False
        end as HasProfileImage
    from dbsnapshots.users as a
    where exists
    (
        select 1
        from apdcs as b
        where a.id = b.channel_id
    )
    and right(id, 1) = @channelDigit
),
events as
(
    select
        channel_id,
        case when count(*) > 0 then True else False end as HasUsedEvents
    from tahoe.oracle_event_server as a
    where action = 'create'
    and exists
    (
        select 1
        from apdcs as b
        where a.channel_id = b.channel_id
    )
    and right(channel_id, 1) = @channelDigit
    group by channel_id
),
panels as
(
    select
        user_id,
        case when count(*) >= 3 then True else False end as MeetsOrExceedsChannelPanelCount
    from dbsnapshots.panels as a
    where exists
    (
        select 1
        from apdcs as b
        where a.user_id = b.channel_id
    )
    and right(user_id, 1) = @channelDigit
    group by user_id
),
chat_rules as
(
    select
        user_id,
        case when count(*) > 0
            then True
            else False
        end as HasUsedRules
    from tahoe.chat_channel_moderation as a
    where action = 'chat_rules'
    and exists
    (
        select 1
        from apdcs as b
        where a.user_id = b.channel_id
    )
    and right(user_id, 1) = @channelDigit
    group by user_id
),
collections as
(
    select
        channel_id,
        case when count(*) > 0 then True else False end as MeetsOrExceedsCollectionsCount
    from tahoe.vod_custom_videos_tab_publish as a
    where exists
    (
        select 1
        from apdcs as b
        where a.channel_id = b.channel_id
    )
    and right(channel_id, 1) = @channelDigit
    group by channel_id
),
automod as
(
    select
        channel_id,
        AutomodEnabled
    from
    (
         select
            channel_id,
            am_active as AutomodEnabled,
            row_number() over(partition by channel_id order by am_active desc) as sort
        from cubes.channel_automod_settings as a
        where exists
        (
            select 1
            from apdcs as b
            where a.channel_id = b.channel_id
        )
        and right(channel_id, 1) = @channelDigit
        and date = (select max(date) from cubes.channel_automod_settings)
    ) as a
    where sort = 1
),
vods as
(
    select
        owner_id,
        case when sum(case when broadcast_type = 'archive' then 1 else 0 end) > 0 then True else False end as MeetsOrExceedsVodCount,
        case when sum(case when broadcast_type = 'highlight' then 1 else 0 end) > 0 then True else False end as MeetsOrExceedsHighlightCount,
        case when sum(case when broadcast_type = 'upload' then 1 else 0 end) > 0 then True else False end as MeetsOrExceedsUploadCount,
        sum(case when broadcast_type = 'upload' then 1 else 0 end) as VodUploadCount
    from dbsnapshots.vods as a
    where exists
    (
        select 1
        from apdcs as b
        where a.owner_id = b.channel_id
    )
    and right(owner_id, 1) = @channelDigit
    group by owner_id
),
emotes as
(
    select
        user_id,
        case when count(*) > 0 then True else False end as MeetsOrExceedsEmoteCount
    from dbsnapshots.user_emoticons as a
    where exists
    (
        select 1
        from apdcs as b
        where a.user_id = b.channel_id
    )
    and right(user_id, 1) = @channelDigit
    group by user_id
),
cheermotes as
(
    select
        channel_id,
        case when count(*) > 0 then True else False end as MeetsOrExceedsCheermoteCount
    from tahoe.bits_partner_cheermote_detail as a
    where exists
    (
        select 1
        from apdcs as b
        where a.channel_id = b.channel_id
    )
    and right(channel_id, 1) = @channelDigit
    group by channel_id
),
clips as
(
    select
        channel_id,
        case when count(*) > 0 then True else False end as MeetsOrExceedsClipCount
    from tahoe.create_clip as a
    where exists
    (
        select 1
        from apdcs as b
        where a.channel_id = b.channel_id
    )
    and right(channel_id, 1) = @channelDigit
    group by channel_id
),
tenure_badges as
(
    select
        channel_id,
        case when count(*) > 0 then True else False end as MeetsOrExceedsTenureBadgeCount
    from tahoe.tenure_badges as a
    where exists
    (
        select 1
        from apdcs as b
        where a.channel_id = b.channel_id
    )
    and right(channel_id, 1) = @channelDigit
    group by channel_id
),
extension_install as
(
    select
        channel_id,
        case when count(*) >= 2 then True else False end as MeetsOrExceedsExtensionInstallCount
    from tahoe.extension_install as a
    where exists
    (
        select 1
        from apdcs as b
        where a.channel_id = b.channel_id
    )
    and right(channel_id, 1) = @channelDigit
    group by channel_id
),
moderators as
(
    select
        channel_id,
        case when count(*) > 0 then True else False end as MeetsOrExceedsModeratorCount
    from dbsnapshots.moderators as a
    where exists
    (
        select 1
        from apdcs as b
        where a.channel_id = b.channel_id
    )
    and right(channel_id, 1) = @channelDigit
    group by channel_id
)
select
    apdcs.channel_id as TwitchUserID,
    apdcs.channel as Login,
    coalesce(apdcs.day, cast('1900-01-01' as datetime)) as DataSourced,
    coalesce(users.HasProfileImage, False) as HasProfileImage,
    coalesce(events.HasUsedEvents, False) as HasUsedEvents,
    coalesce(panels.MeetsOrExceedsChannelPanelCount, False) as MeetsOrExceedsChannelPanelCount,
    coalesce(chat_rules.HasUsedRules, False) as HasUsedRules,
    coalesce(collections.MeetsOrExceedsCollectionsCount, False) as MeetsOrExceedsCollectionsCount,
    coalesce(automod.AutomodEnabled, False) as AutomodEnabled,
    coalesce(vods.MeetsOrExceedsVodCount, False) as MeetsOrExceedsVodCount,
    coalesce(vods.MeetsOrExceedsHighlightCount, False) as MeetsOrExceedsHighlightCount,
    coalesce(vods.MeetsOrExceedsUploadCount, False) as MeetsOrExceedsUploadCount,
    cast(coalesce(vods.VodUploadCount, 0) as bigint) as VodUploadCount,
    coalesce(emotes.MeetsOrExceedsEmoteCount, False) as MeetsOrExceedsEmoteCount,
    coalesce(cheermotes.MeetsOrExceedsCheermoteCount, False) as MeetsOrExceedsCheermoteCount,
    coalesce(clips.MeetsOrExceedsClipCount, False) as MeetsOrExceedsClipCount,
    coalesce(tenure_badges.MeetsOrExceedsTenureBadgeCount, False) as MeetsOrExceedsTenureBadgeCount,
    coalesce(extension_install.MeetsOrExceedsExtensionInstallCount, False) as MeetsOrExceedsExtensionInstallCount,
    coalesce(moderators.MeetsOrExceedsModeratorCount, False) as MeetsOrExceedsModeratorCount
from apdcs
left join users
    on apdcs.channel_id = users.user_id
left join events
    on apdcs.channel_id = events.channel_id
left join panels
    on apdcs.channel_id = panels.user_id
left join chat_rules
    on apdcs.channel_id = chat_rules.user_id
left join collections
    on apdcs.channel_id = collections.channel_id
left join automod
    on apdcs.channel_id = automod.channel_id
left join vods
    on apdcs.channel_id = vods.owner_id
left join emotes
    on apdcs.channel_id = emotes.user_id
left join cheermotes
    on apdcs.channel_id = cheermotes.channel_id
left join clips
    on apdcs.channel_id = clips.channel_id
left join tenure_badges
    on apdcs.channel_id = tenure_badges.channel_id
left join extension_install
    on apdcs.channel_id = extension_install.channel_id
left join moderators
    on apdcs.channel_id = moderators.channel_id
;
/* END USER SCORECARD QUERY */