with apdcs_maxdate as
(
    select max(day) as max_date
    from cubes.affiliates_partners_daily_channel_summary
),
apdcs_base as
(
    select
        channel_id,
        max(day) as max_date,
        case
            when sum 
            (
                coalesce(gross_ad_revenue, 0.0)
                + coalesce(gross_sub_revenue_total, 0.0)
                + coalesce(creator_sub_revenue_prime, 0.0)
                + coalesce(creator_bits_revenue_total, 0.0)
                + coalesce(creator_fuel_revenue, 0.0)
                + coalesce(creator_bounty_board_revenue, 0.0)
            ) >= 1000
            then true 
            else false 
        end as meets_dollar_threshold_lifetime
    from cubes.affiliates_partners_daily_channel_summary
    group by channel_id
), apdcs_365 as
(
    select
        channel_id,
        max(day) as max_date,
        case
            when sum 
            (
                coalesce(gross_ad_revenue, 0.0)
                + coalesce(gross_sub_revenue_total, 0.0)
                + coalesce(creator_sub_revenue_prime, 0.0)
                + coalesce(creator_bits_revenue_total, 0.0)
                + coalesce(creator_fuel_revenue, 0.0)
                + coalesce(creator_bounty_board_revenue, 0.0)
            ) >= 50 
            then true 
            else false 
        end as meets_dollar_threshold_365
    from cubes.affiliates_partners_daily_channel_summary
    where day >= date_trunc('day', getdate() - interval '365 days')
    group by channel_id
    having
    sum
    (
        coalesce(gross_ad_revenue, 0.0)
        + coalesce(gross_sub_revenue_total, 0.0)
        + coalesce(creator_sub_revenue_prime, 0.0)
        + coalesce(creator_bits_revenue_total, 0.0)
        + coalesce(creator_fuel_revenue, 0.0)
        + coalesce(creator_bounty_board_revenue, 0.0)
    ) >= 50
),
apdcs_partner as
(
    select
        channel_id,
        true as is_partner
    from cubes.affiliates_partners_daily_channel_summary as a
    where
        day = (select max(day) from cubes.affiliates_partners_daily_channel_summary as b where a.channel_id = b.channel_id)
        and is_partner = true
    group by channel_id
),
apdcs_premium as
(
    select
        channel_id,
        true as is_premium
    from cubes.affiliates_partners_daily_channel_summary as a
    where
        day = (select max(day) from cubes.affiliates_partners_daily_channel_summary as b where a.channel_id = b.channel_id)
        and marked_as_premium = true
    group by channel_id
),
custom_amp as
(
    select 
        channel_id, 
        getdate() as max_date,
        0 as earnings,
        true as meets_dollar_threshold,
        false as is_premium,
        'Custom' as query_source,
        datediff('day', getdate(), getdate()) as age_since_max_date
    from cubes.amp_application_custom_population as a
),
selection as
(
    select
        apdcs_base.channel_id,
        apdcs_base.max_date,
        apdcs_base.meets_dollar_threshold_lifetime,
        coalesce(apdcs_365.meets_dollar_threshold_365, false) as meets_dollar_threshold_365,
        coalesce(apdcs_partner.is_partner, false) as is_partner,
        coalesce(apdcs_premium.is_premium, false) as is_premium,
        case
            when apdcs_365.channel_id is not null then 'Earnings365'
            when apdcs_premium.channel_id is not null then 'Premium'
            when apdcs_partner.channel_id is not null then 'Partner'
            when apdcs_base.meets_dollar_threshold_lifetime = true then 'EarningsLifetime'
            else 'General'
        end as query_source,
        datediff('day', apdcs_base.max_date, getdate()) as age_since_max_date
    from
        apdcs_base
    left join apdcs_365
        on apdcs_base.channel_id = apdcs_365.channel_id
    left join apdcs_partner
        on apdcs_base.channel_id = apdcs_partner.channel_id
    left join apdcs_premium
        on apdcs_base.channel_id = apdcs_premium.channel_id
    where
        apdcs_base.meets_dollar_threshold_lifetime = true
        or coalesce(apdcs_365.meets_dollar_threshold_365, false) = true
        or coalesce(apdcs_partner.is_partner, false) = true
        or coalesce(apdcs_premium.is_premium, false) = true
)
select
    channel_id,
    max_date,
    meets_dollar_threshold_lifetime,
    meets_dollar_threshold_365,
    is_partner,
    is_premium,
    query_source,
    age_since_max_date
from selection
where
    age_since_max_date <= 30

union all

select
    cast(custom_amp.channel_id as bigint) as channel_id,
    getdate() as max_date,
    true as meets_dollar_threshold_lifetime,
    true as meets_dollar_threshold_365,
    false as is_partner,
    false as is_premium,
    'Custom' as query_source,
    0 as age_since_max_date
from custom_amp
left join selection
  on custom_amp.channel_id = selection.channel_id
where
    selection.channel_id is null