with rawbase as
(
    select channel_id, country_code, fragment, country_count, unique_ip_count
    from
    (
        select channel_id, country_code, fragment, country_count, unique_ip_count from cubes.amp_channel_country_ranking_fragment_60
        union all select channel_id, country_code, fragment, country_count, unique_ip_count from cubes.amp_channel_country_ranking_fragment_50
        union all select channel_id, country_code, fragment, country_count, unique_ip_count from cubes.amp_channel_country_ranking_fragment_40
        union all select channel_id, country_code, fragment, country_count, unique_ip_count from cubes.amp_channel_country_ranking_fragment_30
        union all select channel_id, country_code, fragment, country_count, unique_ip_count from cubes.amp_channel_country_ranking_fragment_20
        union all select channel_id, country_code, fragment, country_count, unique_ip_count from cubes.amp_channel_country_ranking_fragment_10
    ) as rawdata
),
unique_channels as
(
    select channel_id
    from rawbase
    group by channel_id
),
base_countries as
(
    select
    channel_id,
    coalesce(country_code, 'UNKNOWN') as country_code,
    coalesce(b.country_name, 'UNKNOWN') as country_name,
    sum(country_count) as total_country_count_individual,
    row_number() over (partition by channel_id order by sum(country_count) desc) as rank
    from rawbase as a
    left join warehouse.dim_country as b
    on a.country_code = b.country_code_two_letter
    group by
    channel_id,
    coalesce(country_code, 'UNKNOWN'),
    coalesce(b.country_name, 'UNKNOWN')
),
summaries as
(
    select
        a.channel_id,
        sum(a.country_count) as total_country_count,
        sum(case when b.country_code_two_letter is not null then a.country_count else 0 end) as total_country_count_known,
        sum(case when b.country_code_two_letter is null then a.country_count else 0 end) as total_country_count_unknown,
        case
            when sum(a.country_count) > 0 
            then sum(case when b.country_code_two_letter is not null then a.country_count else 0 end)::float / sum(a.country_count)::float * 100.0::float
            else 0
        end as total_country_count_known_percent,
        case
            when sum(a.country_count) > 0 
            then sum(case when b.country_code_two_letter is null then a.country_count else 0 end)::float / sum(a.country_count)::float * 100.0::float
            else 0
        end as total_country_count_unknown_percent
    from rawbase as a
    left join warehouse.dim_country as b
        on a.country_code = b.country_code_two_letter
    group by
        a.channel_id
)
select
    a.channel_id,
    c.country_code,
    c.country_name,
    b.total_country_count as total_count,
    b.total_country_count_known as total_count_known,
    b.total_country_count_unknown as total_count_unknown,
    b.total_country_count_known_percent as total_known_percent,
    b.total_country_count_unknown_percent as total_unknown_percent,
    c.total_country_count_individual::float / b.total_country_count::float * 100.0::float as country_percent,
    c.rank
from unique_channels as a
left join summaries as b
    on a.channel_id = b.channel_id
left join base_countries as c
    on a.channel_id = c.channel_id
