/* BEGIN AMP CHANNEL GAME STATISTICS QUERY */

with stats as
(
  select
    date as day,
    rails_channel_id as channel_id,
    rails_meta_game as game_name,
    count(distinct date_trunc('minute', time)) as minutes_broadcast,
    sum(usher_channel_count) as minutes_watched_total,
    count(distinct usher_stream_up_timestamp) as game_start_count,
    max(usher_channel_count) as peak_viewership,
    avg(usher_channel_count::float) as average_viewership,
    count(*) as item_count_to_find_average_with_minutes_watched_total_over_time
  from tahoe.jax_live_channel
  where
    date >= dateadd(day, -360, date_trunc('day', getdate()))
    and date < date_trunc('day', getdate())
  group by
    date,
    rails_channel_id,
    rails_meta_game
),
games as
(
    select game_id, giantbomb_id, game_name
    from 
    (
        select game_id, giantbomb_id, game_name, row_number() over (partition by game_name order by count(*) desc) as sort, count(*) as cnt
        from
        (
            select game_id, giantbomb_id, game_name
            from
            (
                select id as game_id, giantbomb_id, name as game_name
                from dbsnapshots.games

                union all

                select game_id, b.giantbomb_id, alias as game_name
                from dbsnapshots.game_aliases as a
                left join dbsnapshots.games as b
                on a.game_id = b.id
            ) as a
            group by game_id, giantbomb_id, game_name
        ) as a
        group by game_id, giantbomb_id, game_name
    ) as a
    where sort = 1
)
select
  stats.day,
  stats.channel_id,
  coalesce(stats.game_name, games.game_name) as game_name,
  games.game_id,
  games.giantbomb_id,
  stats.minutes_broadcast as minutes_broadcast_total,
  stats.minutes_watched_total,
  stats.game_start_count,
  stats.peak_viewership,
  stats.average_viewership,
  stats.item_count_to_find_average_with_minutes_watched_total_over_time
from stats
left join games
  on stats.game_name = games.game_name

  /* END AMP CHANNEL GAME STATISTICS QUERY */