with emotes as
(
    select
        emoticons.ticket_product_owner_id as channel_id,
        case
            when tickets.ticket_type = 'chansub' and tickets.interval_unit = 'month' and tickets.recurring = true and tickets.default_price = 999 and right (tickets.short_name,5) = '_2000' then 'tier_2'
            when tickets.ticket_type = 'chansub' and tickets.interval_unit = 'month' and tickets.recurring = true and tickets.default_price = 2499 and right (tickets.short_name,5) = '_3000' then 'tier_3'
            when tickets.ticket_type = 'chansub' and tickets.interval_unit = 'month' and tickets.recurring = true and tickets.default_price = 499 then 'tier_1'
            else 'custom'
        end AS tier_type,
        emoticons.ticket_product_type,
        'emote' as icon_type,
        substring(emoticons.emoticon_url, 0, (length(emoticons.emoticon_url) + 2) - strpos(reverse(emoticons.emoticon_url), '/')) as base_url,
        '1.0' as small_url_fragment,
        '2.0' as medium_url_fragment,
        '3.0' as large_url_fragment,
        emoticons.regex_display
    from cubes.emoticons_enriched as emoticons
    inner join dbsnapshots.ticket_products as tickets
        on emoticons.ticket_product_id = tickets.id
    where
        emoticons.ticket_product_availability_state = 'active'
        and emoticons.state = 'active'
)
select
    channel_id,
    regex_display,
    tier_type,
    ticket_product_type as product_type,
    icon_type,
    base_url,
    small_url_fragment,
    medium_url_fragment,
    large_url_fragment
from emotes