with channel_asn_map as
(
    select
        a.channel_id,
        a.client_asn,
        a.fragment,
        a.unique_ip_count as channel_unique_ip_count,
        a.ip_count as channel_ip_count,
        b.country_code,
        b.country_name,
        b.count_asn as asn_count
    from cubes.amp_viewbot_asn_channel_map as a
    inner join cubes.amp_viewbot_asn_country_map as b
        on a.client_asn = b.client_asn
        and a.fragment = b.fragment
)
select
    channel_id,
    client_asn,
    fragment,
    country_code,
    country_name,
    asn_count,
    channel_unique_ip_count,
    channel_ip_count
from channel_asn_map