with country as
(
    select
        country_code_two_letter as country_code,
        country_code_three_letter,
        country_code_numeric,
        country_name
    from warehouse.dim_country
),
channel_country as
(
    select
        channel_id,
        broadcaster_country,
        count(*) as country_minute_broadcast_count,
        row_number() over (partition by channel_id order by count(*) desc) as sort
    from tahoe.minute_broadcast as a
    where
        date >= date_trunc('day', getdate() - interval '60 days')
    group by
        channel_id,
        broadcaster_country
)
select
    a.channel_id,
    b.country_code,
    b.country_name,
    a.country_minute_broadcast_count
from
    channel_country as a
left join country as b
    on a.broadcaster_country = b.country_code
where
    sort = 1