with channel_game as
(
    select
        channel_id,
        game,
        count(*) as game_minute_broadcast_count,
        row_number() over (partition by channel_id order by count(*) desc) as sort
    from tahoe.minute_broadcast
    where
        date >= date_trunc('day', getdate() - interval '60 days')
    group by
        channel_id,
        game
)
select
    channel_id,
    game,
    game_minute_broadcast_count
from
    channel_game
where
    sort = 1