with channel_language as
(
    select
        channel_id,
        language,
        count(*) as language_minute_broadcast_count,
        row_number() over (partition by channel_id order by count(*) desc) as sort
    from tahoe.minute_broadcast
    where
        date >= date_trunc('day', getdate() - interval '60 days')
    group by
        channel_id,
        language
)
select
    channel_id,
    language,
    language_minute_broadcast_count
from
    channel_language
where
    sort = 1