/* 60 Day Fragment */
select
    esp.client_asn,
    '60-50' as fragment,
    count(*) as count_total,
    count(distinct user_id) as unique_user_count,
    count(distinct client_ip) as unique_ip_count
from tahoe.edge_segment_playlist esp
where
    date >= date_trunc('day', getdate() - interval '60 days')
    and date < date_trunc('day', getdate() - interval '50 days')
group by
    esp.client_asn
    
/* 50 Day Fragment */
select
    esp.client_asn,
    '50-40' as fragment,
    count(*) as count_total,
    count(distinct user_id) as unique_user_count,
    count(distinct client_ip) as unique_ip_count
from tahoe.edge_segment_playlist esp
where
    date >= date_trunc('day', getdate() - interval '50 days')
    and date < date_trunc('day', getdate() - interval '40 days')
group by
    esp.client_asn
    
/* 40 Day Fragment */
select
    esp.client_asn,
    '40-30' as fragment,
    count(*) as count_total,
    count(distinct user_id) as unique_user_count,
    count(distinct client_ip) as unique_ip_count
from tahoe.edge_segment_playlist esp
where
    date >= date_trunc('day', getdate() - interval '40 days')
    and date < date_trunc('day', getdate() - interval '30 days')
group by
    esp.client_asn

/* 30 Day Fragment */
select
    esp.client_asn,
    '30-20' as fragment,
    count(*) as count_total,
    count(distinct user_id) as unique_user_count,
    count(distinct client_ip) as unique_ip_count
from tahoe.edge_segment_playlist esp
where
    date >= date_trunc('day', getdate() - interval '30 days')
    and date < date_trunc('day', getdate() - interval '20 days')
group by
    esp.client_asn

/* 20 Day Fragment */
select
    esp.client_asn,
    '20-10' as fragment,
    count(*) as count_total,
    count(distinct user_id) as unique_user_count,
    count(distinct client_ip) as unique_ip_count
from tahoe.edge_segment_playlist esp
where
    date >= date_trunc('day', getdate() - interval '20 days')
    and date < date_trunc('day', getdate() - interval '10 days')
group by
    esp.client_asn
    
/* 10 Day Fragment */
select
    esp.client_asn,
    '10-0' as fragment,
    count(*) as count_total,
    count(distinct user_id) as unique_user_count,
    count(distinct client_ip) as unique_ip_count
from tahoe.edge_segment_playlist esp
where
    date >= date_trunc('day', getdate() - interval '10 days')
    and date < date_trunc('day', getdate() - interval '0 days')
group by
    esp.client_asn

/* Consolidation query */
select client_asn, fragment, count_total, unique_user_count, unique_ip_count from cubes.amp_viewbot_asn_user_ip_count_fragment_60
union all
select client_asn, fragment, count_total, unique_user_count, unique_ip_count from cubes.amp_viewbot_asn_user_ip_count_fragment_50
union all
select client_asn, fragment, count_total, unique_user_count, unique_ip_count from cubes.amp_viewbot_asn_user_ip_count_fragment_40
union all
select client_asn, fragment, count_total, unique_user_count, unique_ip_count from cubes.amp_viewbot_asn_user_ip_count_fragment_30
union all
select client_asn, fragment, count_total, unique_user_count, unique_ip_count from cubes.amp_viewbot_asn_user_ip_count_fragment_20
union all
select client_asn, fragment, count_total, unique_user_count, unique_ip_count from cubes.amp_viewbot_asn_user_ip_count_fragment_10