with asn_counts_60_day_fragment as
(
    select
        esp.client_asn,
        '60-50' as fragment,
        count(*) as count_total,
        count(distinct user_id) as unique_user_count,
        count(distinct client_ip) as unique_ip_count
    from tahoe.edge_segment_playlist esp
    where
        date >= date_trunc('day', getdate() - interval '60 days')
        and date < date_trunc('day', getdate() - interval '50 days')
    group by
        esp.client_asn
),
asn_counts_50_day_fragment as
(
    select
        esp.client_asn,
        '50-40' as fragment,
        count(*) as count_total,
        count(distinct user_id) as unique_user_count,
        count(distinct client_ip) as unique_ip_count
    from tahoe.edge_segment_playlist esp
    where
        date >= date_trunc('day', getdate() - interval '50 days')
        and date < date_trunc('day', getdate() - interval '40 days')
    group by
        esp.client_asn
),
asn_counts_40_day_fragment as
(
    select
        esp.client_asn,
        '40-30' as fragment,
        count(*) as count_total,
        count(distinct user_id) as unique_user_count,
        count(distinct client_ip) as unique_ip_count
    from tahoe.edge_segment_playlist esp
    where
        date >= date_trunc('day', getdate() - interval '40 days')
        and date < date_trunc('day', getdate() - interval '30 days')
    group by
        esp.client_asn
),
asn_counts_30_day_fragment as
(
    select
        esp.client_asn,
        '30-20' as fragment,
        count(*) as count_total,
        count(distinct user_id) as unique_user_count,
        count(distinct client_ip) as unique_ip_count
    from tahoe.edge_segment_playlist esp
    where
        date >= date_trunc('day', getdate() - interval '30 days')
        and date < date_trunc('day', getdate() - interval '20 days')
    group by
        esp.client_asn
),
asn_counts_20_day_fragment as
(
    select
        esp.client_asn,
        '20-10' as fragment,
        count(*) as count_total,
        count(distinct user_id) as unique_user_count,
        count(distinct client_ip) as unique_ip_count
    from tahoe.edge_segment_playlist esp
    where
        date >= date_trunc('day', getdate() - interval '20 days')
        and date < date_trunc('day', getdate() - interval '10 days')
    group by
        esp.client_asn
),
asn_counts_10_day_fragment as
(
    select
        esp.client_asn,
        '10-0' as fragment,
        count(*) as count_total,
        count(distinct user_id) as unique_user_count,
        count(distinct client_ip) as unique_ip_count
    from tahoe.edge_segment_playlist esp
    where
        date >= date_trunc('day', getdate() - interval '10 days')
        and date < date_trunc('day', getdate() - interval '0 days')
    group by
        esp.client_asn
)
select
    client_asn,
    count_total,
    unique_user_count,
    unique_ip_count
from asn_counts_60_day_fragment

union all

select
    client_asn,
    count_total,
    unique_user_count,
    unique_ip_count
from asn_counts_50_day_fragment

union all

select
    client_asn,
    count_total,
    unique_user_count,
    unique_ip_count
from asn_counts_40_day_fragment

union all

select
    client_asn,
    count_total,
    unique_user_count,
    unique_ip_count
from asn_counts_30_day_fragment

union all

select
    client_asn,
    count_total,
    unique_user_count,
    unique_ip_count
from asn_counts_20_day_fragment

union all

select
    client_asn,
    count_total,
    unique_user_count,
    unique_ip_count
from asn_counts_10_day_fragment