with max_asn_id_60_days as
(
    select
        channel_id,
        max(client_asn_id) as client_asn_id
    from tahoe.edge_segment_playlist
    where date >= date_trunc('day', getdate() - interval '60 days')
    group by
        channel_id
),
channel_asn_60_day_frament as
(
    select
        esp.channel_id,
        esp.client_asn,
        '60-50' as fragment,
        count(distinct esp.client_ip) as unique_ip_count,
        count(*) as ip_count
    from tahoe.edge_segment_playlist as esp
    inner join max_asn_id_60_days as max_asn
        on esp.channel_id = max_asn.channel_id
        and esp.client_asn_id = max_asn.client_asn_id
    where
        date >= date_trunc('day', getdate() - interval '60 days')
        and date < date_trunc('day', getdate() - interval '50 days')
    group by
        esp.channel_id,
        esp.client_asn
),
channel_asn_50_day_frament as
(
    select
        esp.channel_id,
        esp.client_asn,
        '50-40' as fragment,
        count(distinct esp.client_ip) as unique_ip_count,
        count(*) as ip_count
    from tahoe.edge_segment_playlist as esp
    inner join max_asn_id_60_days as max_asn
        on esp.channel_id = max_asn.channel_id
        and esp.client_asn_id = max_asn.client_asn_id
    where
        date >= date_trunc('day', getdate() - interval '50 days')
        and date < date_trunc('day', getdate() - interval '40 days')
    group by
        esp.channel_id,
        esp.client_asn
),
channel_asn_40_day_frament as
(
    select
        esp.channel_id,
        esp.client_asn,
        '40-30' as fragment,
        count(distinct esp.client_ip) as unique_ip_count,
        count(*) as ip_count
    from tahoe.edge_segment_playlist as esp
    inner join max_asn_id_60_days as max_asn
        on esp.channel_id = max_asn.channel_id
        and esp.client_asn_id = max_asn.client_asn_id
    where
        date >= date_trunc('day', getdate() - interval '40 days')
        and date < date_trunc('day', getdate() - interval '30 days')
    group by
        esp.channel_id,
        esp.client_asn
),
channel_asn_30_day_frament as
(
    select
        esp.channel_id,
        esp.client_asn,
        '30-20' as fragment,
        count(distinct esp.client_ip) as unique_ip_count,
        count(*) as ip_count
    from tahoe.edge_segment_playlist as esp
    inner join max_asn_id_60_days as max_asn
        on esp.channel_id = max_asn.channel_id
        and esp.client_asn_id = max_asn.client_asn_id
    where
        date >= date_trunc('day', getdate() - interval '30 days')
        and date < date_trunc('day', getdate() - interval '20 days')
    group by
        esp.channel_id,
        esp.client_asn
),
channel_asn_20_day_frament as
(
    select
        esp.channel_id,
        esp.client_asn,
        '20-10' as fragment,
        count(distinct esp.client_ip) as unique_ip_count,
        count(*) as ip_count
    from tahoe.edge_segment_playlist as esp
    inner join max_asn_id_60_days as max_asn
        on esp.channel_id = max_asn.channel_id
        and esp.client_asn_id = max_asn.client_asn_id
    where
        date >= date_trunc('day', getdate() - interval '20 days')
        and date < date_trunc('day', getdate() - interval '10 days')
    group by
        esp.channel_id,
        esp.client_asn
),
channel_asn_10_day_frament as
(
    select
        esp.channel_id,
        esp.client_asn,
        '10-0' as fragment,
        count(distinct esp.client_ip) as unique_ip_count,
        count(*) as ip_count
    from tahoe.edge_segment_playlist as esp
    inner join max_asn_id_60_days as max_asn
        on esp.channel_id = max_asn.channel_id
        and esp.client_asn_id = max_asn.client_asn_id
    where
        date >= date_trunc('day', getdate() - interval '10 days')
        and date < date_trunc('day', getdate() - interval '0 days')
    group by
        esp.channel_id,
        esp.client_asn
)
select channel_id, client_asn, fragment, unique_ip_count, ip_count from channel_asn_60_day_frament
union all
select channel_id, client_asn, fragment, unique_ip_count, ip_count from channel_asn_50_day_frament
union all
select channel_id, client_asn, fragment, unique_ip_count, ip_count from channel_asn_40_day_frament
union all
select channel_id, client_asn, fragment, unique_ip_count, ip_count from channel_asn_30_day_frament
union all
select channel_id, client_asn, fragment, unique_ip_count, ip_count from channel_asn_20_day_frament
union all
select channel_id, client_asn, fragment, unique_ip_count, ip_count from channel_asn_10_day_frament